# Release 24.11 (“Vicuña”, 2024.11/??) {#sec-release-24.11}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Highlights {#sec-release-24.11-highlights}

- **This will be the last release of Nixpkgs to support macOS Sierra 10.12 to macOS Catalina 10.15.**
  Starting with release 25.05, the minimum supported version will be macOS Big Sur 11, and we cannot guarantee that packages will continue to work on older versions of macOS.
  Users on old macOS versions should consider upgrading to a supported version (potentially using [OpenCore Legacy Patcher](https://dortania.github.io/OpenCore-Legacy-Patcher/) for old hardware) or installing NixOS.
  If neither of those options are viable and you require new versions of software, [MacPorts](https://www.macports.org/) supports back to Mac OS X Snow Leopard 10.6.
- Nix was updated to 2.24, which brings a lot of improvements and fixes. See the release notes for
    [2.19](https://nix.dev/manual/nix/latest/release-notes/rl-2.19),
    [2.20](https://nix.dev/manual/nix/latest/release-notes/rl-2.20),
    [2.21](https://nix.dev/manual/nix/latest/release-notes/rl-2.21),
    [2.22](https://nix.dev/manual/nix/latest/release-notes/rl-2.22),
    [2.23](https://nix.dev/manual/nix/latest/release-notes/rl-2.23),
    [2.24](https://nix.dev/manual/nix/latest/release-notes/rl-2.24).
  Notable changes include improvements to Git fetching, documentation comment support in `nix-repl> :doc`, as well as many quality of life improvements.

- Convenience options for `amdgpu`, open source driver for Radeon cards, is now available under `hardware.amdgpu`.

- [AMDVLK](https://github.com/GPUOpen-Drivers/AMDVLK), AMD's open source Vulkan driver, is now available to be configured as `hardware.amdgpu.amdvlk` option.
  This also allows configuring runtime settings of AMDVLK and enabling experimental features.
- The `moonlight-qt` package ([Moonlight game streaming](https://moonlight-stream.org/)) now has HDR support on Linux systems.

- PostgreSQL now defaults to major version 16.

- `authelia` has been upgraded to version 4.38. This version brings several features and improvements which are detailed in the [release blog post](https://www.authelia.com/blog/4.38-release-notes/).
  This release also deprecates some configuration keys, which are likely to be removed in future version 5.0, but they are still supported and expected to be working in the current version.

- `compressDrv` can compress selected files in a derivation. `compressDrvWeb` compresses files for common web server usage (`.gz` with `zopfli`, `.br` with `brotli`).

- `hardware.display` is a new module implementing workarounds for misbehaving monitors
  through setting up custom EDID files and forcing kernel/framebuffer modes.

- A new display-manager `services.displayManager.ly` was added.
  It is a tui based replacement of sddm and lightdm for window manager users.
  Users can use it by `services.displayManager.ly.enable` and config it by
  `services.displayManager.ly.settings` to generate `/etc/ly/config.ini`

- The default sound server for most graphical sessions has been switched from PulseAudio to PipeWire.
  Users that want to keep PulseAudio will want to set `services.pipewire.enable = false;` and `hardware.pulseaudio.enable = true;`.
  There is currently no plan to fully deprecate and remove PulseAudio, however, PipeWire should generally be preferred for new installs.

- The Rust rewrite of the `switch-to-configuration` program is now used for system activation by default.
  If you experience any issues, please report them.
  The original Perl script can still be used for now by setting `system.switch.enableNg` to `false`.

- The [Xen Hypervisor](https://xenproject.org) is once again available as a virtualisation option under [`virtualisation.xen`](#opt-virtualisation.xen.enable).
  - This release includes Xen [4.17.5](https://wiki.xenproject.org/wiki/Xen_Project_4.17_Release_Notes), [4.18.3](https://wiki.xenproject.org/wiki/Xen_Project_4.18_Release_Notes) and [4.19.0](https://wiki.xenproject.org/wiki/Xen_Project_4.19_Release_Notes), as well as support for booting the hypervisor on EFI systems.
  ::: {.warning}
      Booting into Xen through a legacy BIOS bootloader or with the legacy script-based Stage 1 initrd have been **deprecated**. Only EFI booting and the new systemd-based Stage 1 initrd are supported.
  :::
  - There are two flavours of Xen available by default: `xen`, which includes all built-in components, and `xen-slim`, which replaces the built-in components with their Nixpkgs equivalents.
    - The `qemu-xen-traditional` component has been deprecated by upstream Xen, and is no longer available in any of the Xen packages.
  - The OCaml-based Xen Store can now be configured using  [`virtualisation.xen.store.settings`](#opt-virtualisation.xen.store.settings).
  - The `virtualisation.xen.bridge` options have been deprecated in this release cycle. Users who need network bridges are encouraged to set up their own networking configurations.

## New Modules {#sec-release-24.11-new-modules}

- [TaskChampion Sync-Server](https://github.com/GothenburgBitFactory/taskchampion-sync-server), a [Taskwariror 3](https://taskwarrior.org/docs/upgrade-3/) sync server, replacing Taskwarrior 2's sync server named [`taskserver`](https://github.com/GothenburgBitFactory/taskserver).

- [FlareSolverr](https://github.com/FlareSolverr/FlareSolverr), proxy server to bypass Cloudflare protection. Available as [services.flaresolverr](#opt-services.flaresolverr.enable) service.

- [Gancio](https://gancio.org/), a shared agenda for local communities. Available as [services.gancio](#opt-services.gancio.enable).

- [Goatcounter](https://www.goatcounter.com/), Easy web analytics. No tracking of personal data. Available as [services.goatcounter](options.html#opt-services.goatcocunter.enable).

- [UWSM](https://github.com/Vladimir-csp/uwsm), a wayland session manager to wrap Wayland Compositors into useful systemd units such as `graphical-session.target`. Available as [programs.uwsm](#opt-programs.uwsm.enable).

- [Open-WebUI](https://github.com/open-webui/open-webui), a user-friendly WebUI
  for LLMs. Available as [services.open-webui](#opt-services.open-webui.enable)
  service.

- [Quickwit](https://quickwit.io), sub-second search & analytics engine on cloud storage. Available as [services.quickwit](options.html#opt-services.quickwit).

- [Userborn](https://github.com/nikstur/userborn), a service for declarative
  user management. This can be used instead of the `update-users-groups.pl`
  Perl script and instead of systemd-sysusers. To achieve a system without
  Perl, this is the now recommended tool over systemd-sysusers because it can
  alos create normal users and change passwords. Available as
  [services.userborn](#opt-services.userborn.enable)

- [Flood](https://flood.js.org/), a beautiful WebUI for various torrent clients. Available as [services.flood](options.html#opt-services.flood).

- [Firefly-iii Data Importer](https://github.com/firefly-iii/data-importer), a data importer for Firefly-III. Available as [services.firefly-iii-data-importer](options.html#opt-services.firefly-iii-data-importer)

- [QGroundControl], a ground station support and configuration manager for the PX4 and APM Flight Stacks. Available as [programs.qgroundcontrol](options.html#opt-programs.qgroundcontrol.enable).

- [Eintopf](https://eintopf.info), community event and calendar web application. Available as [services.eintopf](options.html#opt-services.eintopf).

- [Radicle](https://radicle.xyz), an open source, peer-to-peer code collaboration stack built on Git. Available as [services.radicle](#opt-services.radicle.enable).

- [ddns-updater](https://github.com/qdm12/ddns-updater), a service to update DNS records periodically with WebUI for many DNS providers. Available as [services.ddns-updater](#opt-services.ddns-updater.enable).

- [Immersed VR](https://immersed.com/), a closed-source coworking platform. Available as [programs.immersed-vr](#opt-programs.immersed-vr.enable).

- [HomeBox](https://github.com/sysadminsmedia/homebox): the inventory and organization system built for the Home User. Available as [services.homebox](#opt-services.homebox.enable).

- [matrix-hookshot](https://matrix-org.github.io/matrix-hookshot), a Matrix bot for connecting to external services. Available as [services.matrix-hookshot](#opt-services.matrix-hookshot.enable).

- [Renovate](https://github.com/renovatebot/renovate), a dependency updating tool for various git forges and language ecosystems. Available as [services.renovate](#opt-services.renovate.enable).

- [Music Assistant](https://music-assistant.io/), a music library manager for your offline and online music sources which can easily stream your favourite music to a wide range of supported players. Available as [services.music-assistant](#opt-services.music-assistant.enable).

- [zeronsd](https://github.com/zerotier/zeronsd), a DNS server for ZeroTier users. Available with [services.zeronsd.servedNetworks](#opt-services.zeronsd.servedNetworks).

- [wg-access-server](https://github.com/freifunkMUC/wg-access-server/), an all-in-one WireGuard VPN solution with a web ui for connecting devices. Available at [services.wg-access-server](#opt-services.wg-access-server.enable).

- [Pingvin Share](https://github.com/stonith404/pingvin-share), a self-hosted file sharing platform and an alternative for WeTransfer. Available as [services.pingvin-share](#opt-services.pingvin-share.enable).

- [Envision](https://gitlab.com/gabmus/envision), a UI for building, configuring and running Monado, the open source OpenXR runtime. Available as [programs.envision](#opt-programs.envision.enable).

- [Localsend](https://localsend.org/), an open source cross-platform alternative to AirDrop. Available as [programs.localsend](#opt-programs.localsend.enable).

- [cryptpad](https://cryptpad.org/), a privacy-oriented collaborative platform (docs/drive/etc), has been added back. Available as [services.cryptpad](#opt-services.cryptpad.enable).

- [realm](https://github.com/zhboner/realm), a simple, high performance relay server written in rust. Available as [services.realm.enable](#opt-services.realm.enable).

- [Gotenberg](https://gotenberg.dev), an API server for converting files to PDFs that can be used alongside Paperless-ngx. Available as [services.gotenberg](options.html#opt-services.gotenberg).

- [Playerctld](https://github.com/altdesktop/playerctl), a daemon to track media player activity. Available as [services.playerctld](option.html#opt-services.playerctld).

- [MenhirLib](https://gitlab.inria.fr/fpottier/menhir/-/tree/master/coq-menhirlib) A support library for verified Coq parsers produced by Menhir.

- [Glance](https://github.com/glanceapp/glance), a self-hosted dashboard that puts all your feeds in one place. Available as [services.glance](option.html#opt-services.glance).

- [Apache Tika](https://github.com/apache/tika), a toolkit that detects and extracts metadata and text from over a thousand different file types. Available as [services.tika](option.html#opt-services.tika).

- [Misskey](https://misskey-hub.net/en/), an interplanetary microblogging platform. Available as [services.misskey](options.html#opt-services.misskey).

- [Improved File Manager](https://github.com/misterunknown/ifm), or IFM, a single-file web-based file manager. Available as [services.ifm](options.html#opt-services.ifm.enable)

- [OpenGFW](https://github.com/apernet/OpenGFW), an implementation of the Great Firewall on Linux. Available as [services.opengfw](#opt-services.opengfw.enable).

- [Rathole](https://github.com/rapiz1/rathole), a lightweight and high-performance reverse proxy for NAT traversal. Available as [services.rathole](#opt-services.rathole.enable).

- [Proton Mail bridge](https://proton.me/mail/bridge), a desktop application that runs in the background, encrypting and decrypting messages as they enter and leave your computer. It lets you add your Proton Mail account to your favorite email client via IMAP/SMTP by creating a local email server on your computer.

- [chromadb](https://www.trychroma.com/), an open-source AI application
  database. Batteries included. Available as [services.chromadb](options.html#opt-services.chromadb.enable).

- [Wakapi](https://wakapi.dev/), a time tracking software for programmers. Available as [services.wakapi](#opt-services.wakapi.enable).

- [foot](https://codeberg.org/dnkl/foot), a fast, lightweight and minimalistic Wayland terminal emulator. Available as [programs.foot](#opt-programs.foot.enable).

- [ToDesk](https://www.todesk.com/linux.html), a remote desktop applicaton. Available as [services.todesk.enable](#opt-services.todesk.enable).

## Backward Incompatibilities {#sec-release-24.11-incompatibilities}

- `transmission` package has been aliased with a `trace` warning to `transmission_3`. Since [Transmission 4 has been released last year](https://github.com/transmission/transmission/releases/tag/4.0.0), and Transmission 3 will eventually go away, it was decided perform this warning alias to make people aware of the new version. The `services.transmission.package` defaults to `transmission_3` as well because the upgrade can cause data loss in certain specific usage patterns (examples: [#5153](https://github.com/transmission/transmission/issues/5153), [#6796](https://github.com/transmission/transmission/issues/6796)). Please make sure to back up to your data directory per your usage:
  - `transmission-gtk`: `~/.config/transmission`
  - `transmission-daemon` using NixOS module: `${config.services.transmission.home}/.config/transmission-daemon` (defaults to `/var/lib/transmission/.config/transmission-daemon`)

- `androidenv.androidPkgs_9_0` has been removed, and replaced with `androidenv.androidPkgs` for a more complete Android SDK including support for Android 9 and later.

- `grafana` has been updated to version 11.1. This version doesn't support setting `http_addr` to a hostname anymore, an IP address is expected.

- `knot-dns` has been updated to version 3.4.x. Check the [migration guide](https://www.knot-dns.cz/docs/latest/html/migration.html#upgrade-3-3-x-to-3-4-x) for breaking changes.

- `services.kubernetes.kubelet.clusterDns` now accepts a list of DNS resolvers rather than a single string, bringing the module more in line with the upstream Kubelet configuration schema.

- `wstunnel` has had a major version upgrade that entailed rewriting the program in Rust.
  The module was updated to accommodate for breaking changes.
  Breaking changes to the module API were minimised as much as possible,
  but some were nonetheless inevitable due to changes in the upstream CLI.
  Certain options were moved from separate CLI arguments into the forward specifications,
  and those options were also removed from the module's API,
  please consult the wstunnel man page for more detail.
  Also be aware that if you have set additional options in `services.wstunnel.{clients,servers}.<name>.extraArgs`,
  that those might have been removed or modified upstream.

- `clang-tools_<version>` packages have been moved into `llvmPackages_<version>` (i.e. `clang-tools_18` is now `llvmPackages_18.clang-tools`).
  - For convenience, the top-level `clang-tools` attribute remains and is now bound to `llvmPackages.clang-tools`.
  - Top-level `clang_tools_<version>` attributes are now aliases; these will be removed in a future release.

- `buildbot` was updated to 4.0, the AngularJS frontend has been replaced by a React frontend, see the [upstream release notes](https://docs.buildbot.net/current/manual/upgrading/4.0-upgrade.html).

- `nginx` package no longer includes `gd` and `geoip` dependencies. For enabling it, override `nginx` package with the optionals `withImageFilter` and `withGeoIP`.

- `systemd.enableUnifiedCgroupHierarchy` option has been removed.
  In systemd 256 support for cgroup v1 ('legacy' and 'hybrid' hierarchies) is now considered obsolete and systemd by default will refuse to boot under it.
  To forcibly reenable cgroup v1 support, you can `set boot.kernelParams = [ "systemd.unified_cgroup_hierachy=0" "SYSTEMD_CGROUP_ENABLE_LEGACY_FORCE=1" ]`.
  NixOS does not officially support this configuration and might cause your system to be unbootable in future versions. You are on your own.

- `nrfutil` which previously pointed to the now-deprecated `pc-nrfutil` python package, has been repackaged under the same name with the new nrfutil tool.

- `openssh` and `openssh_hpn` are now compiled without Kerberos 5 / GSSAPI support in an effort to reduce the attack surface of the components for the majority of users. Users needing this support can
  use the new `opensshWithKerberos` and `openssh_hpnWithKerberos` flavors (e.g. `programs.ssh.package = pkgs.openssh_gssapi`).

- `security.ipa.ipaHostname` now defaults to the value of `networking.fqdn` if
  it is set, instead of the previous hardcoded default of
  `${networking.hostName}.${security.ipa.domain}`.

- The `MSMTP_QUEUE` and `MSMTP_LOG` environment variables accepted by `msmtpq` have now been renamed to `MSMTPQ_Q` and `MSMTPQ_LOG` respectively.

- The fcgiwrap module now allows multiple instances running as distinct users.
  The option `services.fgciwrap` now takes an attribute set of the
  configuration of each individual instance.
  This requires migrating any previous configuration keys from
  `services.fcgiwrap.*` to `services.fcgiwrap.instances.some-instance.*`.
  The ownership and mode of the UNIX sockets created by this service are now
  configurable and private by default.
  Processes also now run as a dynamically allocated user by default instead of
  root.

- The `mautrix-signal` module was adapted to incorporate the configuration rearrangement that resulted from the update to the mautrix bridgev2 architecture. Pre-0.7.0 configurations should continue to work.
  In case you want to update your configuration make sure to check the NixOS manual.

- The nvidia driver no longer defaults to the proprietary driver starting with version 560. You will need to manually set `hardware.nvidia.open` to select the proprietary or open driver.

- `singularity-tools` have the `storeDir` argument removed from its override interface and use `builtins.storeDir` instead.

- Two build helpers in `singularity-tools`, i.e., `mkLayer` and `shellScript`, are deprecated, as they are no longer involved in image-building. Maintainers will remove them in future releases.

- The `rust.toTargetArch`, `rust.toTargetOs`, `rust.toTargetFamily`, `rust.toTargetVendor`, `rust.toRustTarget`, `rust.toRustTargetSpec`, `rust.toRustTargetSpecShort`, and `rust.IsNoStdTarget` functions are deprecated in favour of the `rust.platform.arch`, `rust.platform.os`, `rust.platform.target-family`, `rust.platform.vendor`, `rust.rustcTarget`, `rust.rustcTargetSpec`, `rust.cargoShortTarget`, `rust.cargoEnvVarTarget`, and `rust.isNoStdTarget` platform attributes respectively.

- The `budgie` and `budgiePlugins` scope have been removed and their packages
  moved into the top level scope (i.e., `budgie.budgie-desktop` is now
  `budgie-desktop`)

- The method to safely handle secrets in the `networking.wireless` module has been changed to benefit from a [new feature](https://w1.fi/cgit/hostap/commit/?id=e680a51e94a33591f61edb210926bcb71217a21a) of wpa_supplicant.
  The syntax to refer to secrets has changed slightly and the option `networking.wireless.environmentFile` has been replaced by `networking.wireless.secretsFile`; see the description of the latter for how to upgrade.

- All Cinnamon and XApp packages have been moved to top-level (i.e., `cinnamon.nemo` is now `nemo`).

- All GNOME packages have been moved to top-level (i.e., `gnome.nautilus` is now `nautilus`).

- `services.cgit` now runs as the cgit user by default instead of root.
  This change requires granting access to the repositories to this user or
  setting the appropriate one through `services.cgit.some-instance.user`.

- `nvimpager` was updated to version 0.13.0, which changes the order of user and
  nvimpager settings: user commands in `-c` and `--cmd` now override the
  respective default settings because they are executed later.

- Kubernetes `featureGates` have changed from a `listOf str` to `attrsOf bool`.
  This refactor makes it possible to also disable feature gates, without having
  to use `extraOpts` flags.

  A previous configuration may have looked like this:
  ```nix
  featureGates = [ "EphemeralContainers" ];
  extraOpts = pkgs.lib.concatStringsSep " " (
  [
    ''--feature-gates="CSIMigration=false"''
  });
  ```

  Using an AttrSet instead, the new configuration would be:
  ```nix
  featureGates = {EphemeralContainers = true; CSIMigration=false;};
  ```

- `pkgs.nextcloud27` has been removed since it's EOL.

- `frigate` was updated past 0.14.0. This release includes various breaking changes, so please go read the [release notes](https://github.com/blakeblackshear/frigate/releases/tag/v0.14.0).
   Most prominently access to the webinterface and API are now protected by authentication. Retrieve the auto-created
   admin account from the `frigate.service` journal after upgrading.

- `services.forgejo.mailerPasswordFile` has been deprecated by the drop-in replacement `services.forgejo.secrets.mailer.PASSWD`,
  which is part of the new free-form `services.forgejo.secrets` option.
  `services.forgejo.secrets` is a small wrapper over systemd's `LoadCredential=`. It has the same structure (sections/keys) as
  `services.forgejo.settings` but takes file paths that will be read before service startup instead of some plaintext value.

- `forgejo` and `forgejo-lts` no longer support the opt-in feature [PAM (Pluggable Authentication Module)](https://forgejo.org/docs/latest/user/authentication/#pam-pluggable-authentication-module).

- `gitea` no longer supports the opt-in feature [PAM (Pluggable Authentication Module)](https://docs.gitea.com/usage/authentication#pam-pluggable-authentication-module).

- `services.ddclient.use` has been deprecated: `ddclient` now supports separate IPv4 and IPv6 configuration. Use `services.ddclient.usev4` and `services.ddclient.usev6` instead.

- `services.pgbouncer` systemd service is configured with `Type=notify-reload` and allows reloading configuration without process restart. PgBouncer configuration options were moved to the free-form type option named [`services.pgbouncer.settings`](#opt-services.pgbouncer.settings) according to the NixOS RFC 0042.

- `teleport` has been upgraded from major version 15 to major version 16.
  Refer to upstream [upgrade instructions](https://goteleport.com/docs/management/operations/upgrading/)
  and [release notes for v16](https://goteleport.com/docs/changelog/#1600-061324).

- `tests.overriding` has its `passthru.tests` restructured as an attribute set instead of a list, making individual tests accessible by their names.

- `vaultwarden` lost the capability to bind to privileged ports. If you rely on
   this behavior, override the systemd unit to allow `CAP_NET_BIND_SERVICE` in
   your local configuration.

- The Invoiceplane module now only accepts the structured `settings` option.
  `extraConfig` is now removed.

- The `ollama` services replaces its `sandbox` toggle with options to configure
  a static `user` and `group`. The `writablePaths` option has been removed and
  the models directory is now always exempt from sandboxing.

- Legacy package `stalwart-mail_0_6` was dropped, please note the
  [manual upgrade process](https://github.com/stalwartlabs/mail-server/blob/main/UPGRADING.md)
  before changing the package to `pkgs.stalwart-mail` in
  [`services.stalwart-mail.package`](#opt-services.stalwart-mail.package).

- The `nomad_1_5` package was dropped, as [it has reached end-of-life upstream](https://support.hashicorp.com/hc/en-us/articles/360021185113-Support-Period-and-End-of-Life-EOL-Policy). Evaluating it will throw an error.

- `androidndkPkgs` has been updated to `androidndkPkgs_26`.

- Android NDK version 26 and SDK version 33 are now the default versions used for cross compilation to android.

- the `ankisyncd` package and its `services.ankisyncd` have been removed, use [`services.anki-sync-server`](#opt-services.anki-sync-server.enable) instead.

- `nodePackages.vscode-css-languageserver-bin`, `nodePackages.vscode-html-languageserver-bin`,
  and `nodePackages.vscode-json-languageserver-bin` were dropped due to an unmaintained upstream.
  The `vscode-langservers-extracted` package is a maintained drop-in replacement.

- `nodePackages.prisma` has been replaced by `prisma`.

- `fetchNextcloudApp` has been rewritten to use `fetchurl` rather than
  `fetchzip`. This invalidates all existing hashes but you can restore the old
  behavior by passing it `unpack = true`.

- `haskell.lib.compose.justStaticExecutables` now disallows references to GHC in the
  output by default, to alert users to closure size issues caused by
  [#164630](https://github.com/NixOS/nixpkgs/issues/164630). See ["Packaging
  Helpers" in the Haskell section of the Nixpkgs
  manual](https://nixos.org/manual/nixpkgs/unstable/#haskell-packaging-helpers)
  for information on working around `output '...' is not allowed to refer to
  the following paths` errors caused by this change.

- The `stalwart-mail` service now runs under the `stalwart-mail` system user
  instead of a dynamically created one via `DynamicUser`, to avoid automatic
  ownership changes on its large file store each time the service was started.
  This change requires to manually move the state directory from
  `/var/lib/private/stalwart-mail` to `/var/lib/stalwart-mail` and to
  change the ownership of the directory and its content to `stalwart-mail`.

- The `stalwart-mail` module now uses RocksDB as the default storage backend
  for `stateVersion` ≥ 24.11. (It was previously using SQLite for structured
  data and the filesystem for blobs).

- The `stargazer` service has been hardened to improve security, but these
  changes make break certain setups, particularly around traditional CGI.

  - The `stargazer.allowCgiUser` option has been added, enabling
    Stargazer's `cgi-user` option to work, which was previously broken.

- The `shiori` service now requires an HTTP secret value `SHIORI_HTTP_SECRET_KEY` to be provided via environment variable. The nixos module therefore, now provides an environmentFile option:

  ```
  # This is how a environment file can be generated:
  # $ printf "SHIORI_HTTP_SECRET_KEY=%s\n" "$(openssl rand -hex 16)" > /path/to/env-file
  services.shiori.environmentFile = "/path/to/env-file";
  ```

- `/share/nano` is now only linked when `programs.nano.enable` is enabled.

- PPD files for Utax printers got renamed (spaces replaced by underscores) in newest `foomatic-db` package; users of Utax printers might need to adapt their `hardware.printers.ensurePrinters.*.model` value.

- The `kvdo` kernel module package was removed, because it was upstreamed in kernel version 6.9, where it is called `dm-vdo`.

- `libe57format` has been updated to `>= 3.0.0`, which contains some backward-incompatible API changes. See the [release note](https://github.com/asmaloney/libE57Format/releases/tag/v3.0.0) for more details.

- `gitlab` deprecated support for *runner registration tokens* in GitLab 16.0, disabled their support in GitLab 17.0 and will
  ultimately remove it in GitLab 18.0, as outlined in the
  [documentation](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#estimated-time-frame-for-planned-changes).
  After upgrading to GitLab >= 17.0, it is possible to re-enable support for registration tokens in the UI until GitLab 18.0.
  Refer to the manual on [using registration tokens after GitLab 17.0](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#using-registration-tokens-after-gitlab-170).
  GitLab administrators should migrate to the [new runner registration workflow](https://docs.gitlab.com/17.0/ee/ci/runners/new_creation_workflow.html#using-registration-tokens-after-gitlab-170)
  with *runner authentication tokens* until the release of GitLab 18.0.

- `gitlab` has been updated from 16.x to 17.x and requires at least `postgresql` 14.9, as stated in the [documentation](https://docs.gitlab.com/17.1/ee/install/requirements.html#postgresql-requirements). Check the [upgrade guide](#module-services-postgres-upgrading) in the NixOS manual on how to upgrade your PostgreSQL installation.

- `gitaly` (part of `gitlab`) is now using the bundled `git` package instead of `pkgs.git` to maintain compatibility with GitLab.

- `nixos/gitlab` no longer adds `pkgs.git` to `environment.systemPackages` by default.

- The `replay-sorcery` package and module was removed as it unmaintained upstream. Consider using `gpu-screen-recorder` or `obs-studio` instead.

- To follow [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) a few options of `samba` have been moved from `extraConfig` and `configText` to the new freeform option `settings` and renamed, e.g.:
  - `services.samba.invalidUsers` to `services.samba.settings.global."invalid users"`
  - `services.samba.securityType` to `services.samba.settings.global."security type"`
  - `services.samba.shares` to `services.samba.settings`
  - `services.samba.enableWinbindd` to `services.samba.winbindd.enable`
  - `services.samba.enableNmbd` to `services.samba.nmbd.enable`

- `zx` was updated to v8, which introduces several breaking changes.
  See the [v8 changelog](https://github.com/google/zx/releases/tag/8.0.0) for more information.

- The `dnscrypt-wrapper` module was removed since the project has been effectively unmaintained since 2018; moreover the NixOS module had to rely on an abandoned version of dnscrypt-proxy v1 for the rotation of keys.
  To wrap a resolver with DNSCrypt you can instead use `dnsdist`. See options `services.dnsdist.dnscrypt.*`

- The `portunus` package and service do not support weak password hashes anymore.
  If you installed Portunus on NixOS 23.11 or earlier, upgrade to NixOS 24.05 first to get support for strong password hashing.
  Then, follow the instructions on the [upstream release notes](https://github.com/majewsky/portunus/releases/tag/v2.0.0) to upgrade all existing user accounts to strong password hashes.
  If you need to upgrade to 24.11 without having completed the migration, consider the security implications of weak password hashes on your user accounts, and add the following to your configuration:
  ```nix
  services.portunus.package      = pkgs.portunus.override { libxcrypt = pkgs.libxcrypt-legacy; };
  services.portunus.ldap.package = pkgs.openldap.override { libxcrypt = pkgs.libxcrypt-legacy; };
  ```

- The default value of `services.kubernetes.kubelet.hostname` is now lowercased.
  Explicitly set `kubelet.hostname` to `networking.fqdnOrHostName` to get back
  the old default behavior.

- Docker now defaults to 27.x, because version 24.x stopped receiving security updates and bug fixes after [February 1, 2024](https://github.com/moby/moby/pull/46772#discussion_r1686464084).

- `postgresql` was split into default and -dev outputs. To make this work without circular dependencies, the output of the `pg_config` system view has been removed. The `pg_config` binary is provided in the -dev output and still works as expected.

- `keycloak` was updated to version 25, which introduces new hostname related options.
  See [Upgrading Guide](https://www.keycloak.org/docs/25.0.1/upgrading/#migrating-to-25-0-0) for instructions.

- `programs.vim.defaultEditor` now only works if `programs.vim.enable` is enabled.

- The `indi-full` package no longer contains non-free drivers.
  To get the old collection of drivers use `indi-full-nonfree` or create your own collection of drivers by overriding indi-with-drivers.
  E.g.: `pkgs.indi-with-drivers.override {extraDrivers = with pkgs.indi-3rdparty; [indi-gphoto];}`

- `/share/vim-plugins` now only gets linked if `programs.vim.enable` is enabled

- The `tracy` package no longer works on X11, since it's moved to Wayland
  support, which is the intended default behavior by Tracy maintainers.
  X11 users have to switch to the new package `tracy-x11`.

- The `services.prometheus.exporters.minio` option has been removed, as it's upstream implementation was broken and unmaintained.
  Minio now has built-in [Prometheus metrics exposure](https://min.io/docs/minio/linux/operations/monitoring/collect-minio-metrics-using-prometheus.html), which can be used instead.

- The `services.patroni.raft` option has been removed, as Raft has been [deprecated by upstream since 3.0.0](https://github.com/patroni/patroni/blob/master/docs/releases.rst#version-300)

- `services.roundcube.maxAttachmentSize` will multiply the value set with `1.37` to offset overhead introduced by the base64 encoding applied to attachments.

- The `sound` options have been removed or renamed, as they had a lot of unintended side effects. See [below](#sec-release-24.11-migration-sound) for details.

- The `services.mxisd` module has been removed as both [mxisd](https://github.com/kamax-matrix/mxisd) and [ma1sd](https://github.com/ma1uta/ma1sd) are not maintained any longer.
  Consequently the package `pkgs.ma1sd` has also been removed.

- `ffmpeg_5` has been removed. Please use the unversioned `ffmpeg`,
  pin a newer version, or if necessary pin `ffmpeg_4` for compatibility.

- The `xdg.portal.gtkUsePortal` option has been removed, as it had been deprecated for over 2 years. Using the `GTK_USE_PORTAL` environment variable in this manner is not intended nor encouraged by the GTK developers, but can still be done manually via `environment.sessionVariables`.

- The `services.trust-dns` module has been renamed to `services.hickory-dns`.

- The option `services.prometheus.exporters.pgbouncer.connectionStringFile` has been removed since
  it leaked the connection string (and thus potentially the DB password) into the cmdline
  of process making it effectively world-readable.

  Use [`services.prometheus.exporters.pgbouncer.connectionEnvFile`](#opt-services.prometheus.exporters.pgbouncer.connectionEnvFile) instead.

- The `lsh` package and the `services.lshd` module have been removed as they had no maintainer in Nixpkgs and hadn’t seen an upstream release in over a decade. It is recommended to migrate to `openssh` and `services.openssh`.

- `opencv2` and `opencv3` have been removed, as they are obsolete and
  were not used by any other package. External users are encouraged to
  migrate to OpenCV 4.

- The `tvheadend` package and the `services.tvheadend` module have been
  removed as nobody was willing to maintain them and they were stuck on
  an unmaintained version that required FFmpeg 4; please see [pull
  request #332259](https://github.com/NixOS/nixpkgs/pull/332259) if you
  are interested in maintaining a newer version.

- The `antennas` package and the `services.antennas` module have been
  removed as they only work with `tvheadend` (see above).

- The `system.build.brightboxImage` image has been removed as It did not build anymore and has not seen any maintenance in over 7 years (excluding tree-wide changes).

- The `services.syncplay` module now exposes all currently available command-line arguments for `syncplay-server` as options, as well as a `useACMEHost` option for easy TLS setup.
  The systemd service now uses `DynamicUser`/`StateDirectory` and the `user` and `group` options have been deprecated.

- The `openlens` package got removed, suggested replacment `lens-desktop`

- The NixOS installation media no longer support the ReiserFS or JFS file systems by default.

- Minimal installer ISOs are no longer built on the small channel.
  Please obtain installer images from the full release channels.

## Other Notable Changes {#sec-release-24.11-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- The `zerocallusedregs` hardening flag is enabled by default on compilers that support it.

- The `stackclashprotection` hardening flag has been added, though disabled by default.

- The `pacret` hardening flag has been added, though disabled by default.

- `cargoSha256` in `rustPlatform.buildRustPackage` has been deprecated in favor
  of `cargoHash` which supports SRI hashes. See
  [buildRustPackage: Compiling Rust applications with Cargo](https://nixos.org/manual/nixpkgs/unstable/#compiling-rust-applications-with-cargo)
  for more information.

- The `vendorHash` of Go packages built with `buildGoModule` can now be overridden with `overrideAttrs`.
  `goModules`, `modRoot`, `vendorHash`, `deleteVendor`, and `proxyVendor` are now passed as derivation attributes.
  `goModules` and `vendorHash` are no longer placed under `passthru`.

- `hareHook` has been added as the language framework for Hare. From now on, it,
  not the `hare` package, should be added to `nativeBuildInputs` when building
  Hare programs.

- [`lib.options.mkPackageOptionMD`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.options.mkPackageOptionMD) is now obsolete; use the identical [`lib.options.mkPackageOption`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.options.mkPackageOption) instead.

- `lib.misc.mapAttrsFlatten` is now formally deprecated and will be removed in future releases; use the identical [`lib.attrsets.mapAttrsToList`](https://nixos.org/manual/nixpkgs/unstable#function-library-lib.attrsets.mapAttrsToList) instead.

- `nixosTests` now provide a working IPv6 setup for VLAN 1 by default.

- Kanidm can now be provisioned using the new [`services.kanidm.provision`] option, but requires using a patched version available via `pkgs.kanidm.withSecretProvisioning`.

- Kanidm previously had an incorrect systemd service type, causing dependent units with an `after` and `requires` directive to start before `kanidm*` finished startup. The module has now been updated in line with upstream recommendations.

- The kubelet configuration file can now be amended with arbitrary additional content using the `services.kubernetes.kubelet.extraConfig` option.

- To facilitate dependency injection, the `imgui` package now builds a static archive using vcpkg' CMake rules.
  The derivation now installs "impl" headers selectively instead of by a wildcard.
  Use `imgui.src` if you just want to access the unpacked sources.

- Unprivileged access to the kernel syslog via `dmesg` is now restricted by default. Users wanting to keep an
  unrestricted access to it can set `boot.kernel.sysctl."kernel.dmesg_restrict" = false`.

- The `i18n.inputMethod` module introduces two new properties:
  `enable` and `type`, for declaring whether to enable an alternative input method and defining which input method respectfully. The options available in `type` are the same as the existing `enabled` option. `enabled` is now deprecated, and will be removed in a future release.

- `security.pam.u2f` now follows RFC42.
  All module options are now settable through the freeform `.settings`.

- Gollum was upgraded to major version 6. Read their [migration notes](https://github.com/gollum/gollum/wiki/6.0-Release-Notes).

- The hooks `yarnConfigHook` and `yarnBuildHook` were added. These should replace `yarn2nix.mkYarnPackage` and other `yarn2nix` related tools. The motivation to get rid of `yarn2nix` tools is the fact that they are too complex and hard to maintain, and they rely upon too much Nix evaluation which is problematic if import-from-derivation is not allowed (see more details at [#296856](https://github.com/NixOS/nixpkgs/issues/296856). The transition from `mkYarnPackage` to `yarn{Config,Build}Hook` is tracked at [#324246](https://github.com/NixOS/nixpkgs/issues/324246).

- `services.timesyncd.servers` now defaults to `null`, allowing systemd-timesyncd to use NTP servers advertised by DHCP.

- `services.timesyncd.fallbackServers` was added and defaults to `networking.timeServers`.

- Cinnamon has been updated to 6.2, please check [upstream announcement](https://www.linuxmint.com/rel_wilma_whatsnew.php) for more details.
  Following Mint 22 defaults, the Cinnamon module no longer ships geary and hexchat by default.

- `zfs.latestCompatibleLinuxPackages` is deprecated and is now pointing at the default kernel. If using the stable LTS kernel (default `linuxPackages` is not possible then you must explicitly pin a specific kernel release. For example, `boot.kernelPackages = pkgs.linuxPackages_6_6`. Please be aware that non-LTS kernels are likely to go EOL before ZFS supports the latest supported non-LTS release, requiring manual intervention.

- The `shadowstack` hardening flag has been added, though disabled by default.

- `xxd` is now provided by the `tinyxxd` package, rather than `vim.xxd`, to reduce closure size and vulnerability impact. Since it has the same options and semantics as Vim's `xxd` utility, there is no user impact. Vim's `xxd` remains available as the `vim.xxd` package.

- `prometheus-openldap-exporter` was removed since it was unmaintained upstream and had no nixpkgs maintainers.

- `restic` module now has an option for inhibiting system sleep while backups are running, defaulting to off (not inhibiting sleep), available as [`services.restic.backups.<name>.inhibitsSleep`](#opt-services.restic.backups._name_.inhibitsSleep).

- Support for *runner registration tokens* has been [deprecated](https://gitlab.com/gitlab-org/gitlab/-/issues/380872)
  in `gitlab-runner` 15.6 and is expected to be removed in `gitlab-runner` 18.0. Configuration of existing runners
  should be changed to using *runner authentication tokens* by configuring
  {option}`services.gitlab-runner.services.<name>.authenticationTokenConfigFile` instead of the former
  {option}`services.gitlab-runner.services.<name>.registrationConfigFile` option.

- `iproute2` now has libbpf support.

- `nix.channel.enable = false` no longer implies `nix.settings.nix-path = []`.
  Since Nix 2.13, a `nix-path` set in `nix.conf` cannot be overriden by the `NIX_PATH` configuration variable.

## Detailed migration information {#sec-release-24.11-migration}

### `sound` options removal {#sec-release-24.11-migration-sound}

The `sound` options have been largely removed, as they are unnecessary for most modern setups, and cause issues when enabled.

If you set `sound.enable` in your configuration:
  - If you are using Pulseaudio or PipeWire, simply remove that option
  - If you are not using an external sound server, and want volumes to be persisted across shutdowns, set `hardware.alsa.enablePersistence = true` instead

If you set `sound.enableOSSEmulation` in your configuration:
  - Make sure it is still necessary, as very few applications actually use OSS
  - If necessary, set `boot.kernelModules = [ "snd_pcm_oss" ]`

If you set `sound.extraConfig` in your configuration:
  - If you are using another sound server, like Pulseaudio, JACK or PipeWire, migrate your configuration to that
  - If you are not using an external sound server, set `environment.etc."asound.conf".text = yourExtraConfig` instead

If you set `sound.mediaKeys` in your configuration:
  - Preferably switch to handling media keys in your desktop environment/compositor
  - If you want to maintain the exact behavior of the option, use the following snippet

```nix
services.actkbd = let
  volumeStep = "1%";
in {
  enable = true;
  bindings = [
    # "Mute" media key
    { keys = [ 113 ]; events = [ "key" ];       command = "${alsa-utils}/bin/amixer -q set Master toggle"; }

    # "Lower Volume" media key
    { keys = [ 114 ]; events = [ "key" "rep" ]; command = "${alsa-utils}/bin/amixer -q set Master ${volumeStep}- unmute"; }

    # "Raise Volume" media key
    { keys = [ 115 ]; events = [ "key" "rep" ]; command = "${alsa-utils}/bin/amixer -q set Master ${volumeStep}+ unmute"; }

    # "Mic Mute" media key
    { keys = [ 190 ]; events = [ "key" ];       command = "${alsa-utils}/bin/amixer -q set Capture toggle"; }
  ];
};
```
