# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# Programmable completion for the Breezy brz command under bash.
# Source this file (or add it to your ~/.bash_completion or ~/.bashrc
# file, depending on your system configuration, and start a new shell)
# and bash's completion mechanism will know all about brz's options!
#
# This completion function assumes you have the brz-bash-completion
# plugin installed as a brz plugin. It will generate the full
# completion function at first invocation, thus avoiding long delays
# for every shell you start.

shopt -s progcomp
_brz_lazy ()
{
	unset _brz
	eval "$(brz bash-completion)"
	if [[ $(type -t _brz) == function ]]; then
		unset _brz_lazy
		_brz
		return $?
	else
		return 1
	fi
}
complete -F _brz_lazy -o default brz
