{
  lib,
  buildGoModule,
  fetchFromGitHub,
  installShellFiles,
}:

buildGoModule rec {
  pname = "logdy";
  version = "0.13.0";

  src = fetchFromGitHub {
    owner = "logdyhq";
    repo = "logdy-core";
    rev = "v${version}";
    hash = "sha256-HlIl/4C1wheAxc0ReUN8xQrXJ0djoO7E0qhRwyFHEiE=";
  };

  vendorHash = "sha256-kFhcbBMymzlJ+2zw7l09LJfCdps26Id+VzOehqrLDWU=";

  ldflags = [
    "-s"
    "-w"
  ];

  nativeBuildInputs = [ installShellFiles ];

  # After the build this derivation will generate two binaries.
  # The first one is getting renamed based on the documentation
  # The second one is just to launch a demo. This functionality could be achieved with the first one
  postInstall = ''
    mv $out/bin/logdy-core $out/bin/logdy
    rm -f $out/bin/example-app

    installShellCompletion --cmd logdy \
      --bash <($out/bin/logdy completion bash) \
      --fish <($out/bin/logdy completion fish) \
      --zsh <($out/bin/logdy completion zsh)
  '';

  checkFlags = [
    "-skip=^TestClientLoad$" # index out of range
  ];

  meta = {
    description = "Web based real-time log viewer";
    longDescription = ''
      Web based real-time log viewer.
      Stream ANY content to a web UI with autogenerated filters.
      Parse any format with TypeScript
    '';
    homepage = "https://github.com/logdyhq/logdy-core";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [
      sigmanificient
      ByteSudoer
    ];
    mainProgram = "logdy";
  };
}
