# Release 15.09 ("Dingo", 2015/09/30) {#sec-release-15.09}

In addition to numerous new and upgraded packages, this release has the following highlights:

- The [Haskell](http://haskell.org/) packages infrastructure has been re-designed from the ground up ("Haskell NG"). NixOS now distributes the latest version of every single package registered on [Hackage](http://hackage.haskell.org/) -- well in excess of 8,000 Haskell packages. Detailed instructions on how to use that infrastructure can be found in the [User's Guide to the Haskell Infrastructure](https://nixos.org/nixpkgs/manual/#users-guide-to-the-haskell-infrastructure). Users migrating from an earlier release may find helpful information below, in the list of backwards-incompatible changes. Furthermore, we distribute 51(!) additional Haskell package sets that provide every single [LTS Haskell](http://www.stackage.org/) release since version 0.0 as well as the most recent [Stackage Nightly](http://www.stackage.org/) snapshot. The announcement ["Full Stackage Support in Nixpkgs"](https://nixos.org/nix-dev/2015-September/018138.html) gives additional details.

- Nix has been updated to version 1.10, which among other improvements enables cryptographic signatures on binary caches for improved security.

- You can now keep your NixOS system up to date automatically by setting

```nix
{
  system.autoUpgrade.enable = true;
}
```

This will cause the system to periodically check for updates in your current channel and run `nixos-rebuild`.

- This release is based on Glibc 2.21, GCC 4.9 and Linux 3.18.

- GNOME has been upgraded to 3.16.

- Xfce has been upgraded to 4.12.

- KDE 5 has been upgraded to KDE Frameworks 5.10, Plasma 5.3.2 and Applications 15.04.3. KDE 4 has been updated to kdelibs-4.14.10.

- E19 has been upgraded to 0.16.8.15.

The following new services were added since the last release:

- `services/mail/exim.nix`

- `services/misc/apache-kafka.nix`

- `services/misc/canto-daemon.nix`

- `services/misc/confd.nix`

- `services/misc/devmon.nix`

- `services/misc/gitit.nix`

- `services/misc/ihaskell.nix`

- `services/misc/mbpfan.nix`

- `services/misc/mediatomb.nix`

- `services/misc/mwlib.nix`

- `services/misc/parsoid.nix`

- `services/misc/plex.nix`

- `services/misc/ripple-rest.nix`

- `services/misc/ripple-data-api.nix`

- `services/misc/subsonic.nix`

- `services/misc/sundtek.nix`

- `services/monitoring/cadvisor.nix`

- `services/monitoring/das_watchdog.nix`

- `services/monitoring/grafana.nix`

- `services/monitoring/riemann-tools.nix`

- `services/monitoring/teamviewer.nix`

- `services/network-filesystems/u9fs.nix`

- `services/networking/aiccu.nix`

- `services/networking/asterisk.nix`

- `services/networking/bird.nix`

- `services/networking/charybdis.nix`

- `services/networking/docker-registry-server.nix`

- `services/networking/fan.nix`

- `services/networking/firefox/sync-server.nix`

- `services/networking/gateone.nix`

- `services/networking/heyefi.nix`

- `services/networking/i2p.nix`

- `services/networking/lambdabot.nix`

- `services/networking/mstpd.nix`

- `services/networking/nix-serve.nix`

- `services/networking/nylon.nix`

- `services/networking/racoon.nix`

- `services/networking/skydns.nix`

- `services/networking/shout.nix`

- `services/networking/softether.nix`

- `services/networking/sslh.nix`

- `services/networking/tinc.nix`

- `services/networking/tlsdated.nix`

- `services/networking/tox-bootstrapd.nix`

- `services/networking/tvheadend.nix`

- `services/networking/zerotierone.nix`

- `services/scheduling/marathon.nix`

- `services/security/fprintd.nix`

- `services/security/hologram.nix`

- `services/security/munge.nix`

- `services/system/cloud-init.nix`

- `services/web-servers/shellinabox.nix`

- `services/web-servers/uwsgi.nix`

- `services/x11/unclutter.nix`

- `services/x11/display-managers/sddm.nix`

- `system/boot/coredump.nix`

- `system/boot/loader/loader.nix`

- `system/boot/loader/generic-extlinux-compatible`

- `system/boot/networkd.nix`

- `system/boot/resolved.nix`

- `system/boot/timesyncd.nix`

- `tasks/filesystems/exfat.nix`

- `tasks/filesystems/ntfs.nix`

- `tasks/filesystems/vboxsf.nix`

- `virtualisation/virtualbox-host.nix`

- `virtualisation/vmware-guest.nix`

- `virtualisation/xen-dom0.nix`

When upgrading from a previous release, please be aware of the following incompatible changes:

- `sshd` no longer supports DSA and ECDSA host keys by default. If you have existing systems with such host keys and want to continue to use them, please set

```nix
{
  system.stateVersion = "14.12";
}
```

The new option `system.stateVersion` ensures that certain configuration changes that could break existing systems (such as the `sshd` host key setting) will maintain compatibility with the specified NixOS release. NixOps sets the state version of existing deployments automatically.

- `cron` is no longer enabled by default, unless you have a non-empty `services.cron.systemCronJobs`. To force `cron` to be enabled, set `services.cron.enable = true`.

- Nix now requires binary caches to be cryptographically signed. If you have unsigned binary caches that you want to continue to use, you should set `nix.requireSignedBinaryCaches = false`.

- Steam now doesn't need root rights to work. Instead of using `*-steam-chrootenv`, you should now just run `steam`. `steamChrootEnv` package was renamed to `steam`, and old `steam` package -- to `steamOriginal`.

- CMPlayer has been renamed to bomi upstream. Package `cmplayer` was accordingly renamed to `bomi`

- Atom Shell has been renamed to Electron upstream. Package `atom-shell` was accordingly renamed to `electron`

- Elm is not released on Hackage anymore. You should now use `elmPackages.elm` which contains the latest Elm platform.

- The CUPS printing service has been updated to version `2.0.2`. Furthermore its systemd service has been renamed to `cups.service`.

  Local printers are no longer shared or advertised by default. This behavior can be changed by enabling `services.printing.defaultShared` or `services.printing.browsing` respectively.

- The VirtualBox host and guest options have been named more consistently. They can now found in `virtualisation.virtualbox.host.*` instead of `services.virtualboxHost.*` and `virtualisation.virtualbox.guest.*` instead of `services.virtualboxGuest.*`.

  Also, there now is support for the `vboxsf` file system using the `fileSystems` configuration attribute. An example of how this can be used in a configuration:

```nix
{
  fileSystems."/shiny" = {
    device = "myshinysharedfolder";
    fsType = "vboxsf";
  };
}
```

- "`nix-env -qa`" no longer discovers Haskell packages by name. The only packages visible in the global scope are `ghc`, `cabal-install`, and `stack`, but all other packages are hidden. The reason for this inconvenience is the sheer size of the Haskell package set. Name-based lookups are expensive, and most `nix-env -qa` operations would become much slower if we'd add the entire Hackage database into the top level attribute set. Instead, the list of Haskell packages can be displayed by running:

```ShellSession
nix-env -f "<nixpkgs>" -qaP -A haskellPackages
```

Executable programs written in Haskell can be installed with:

```ShellSession
nix-env -f "<nixpkgs>" -iA haskellPackages.pandoc
```

Installing Haskell _libraries_ this way, however, is no longer supported. See the next item for more details.

- Previous versions of NixOS came with a feature called `ghc-wrapper`, a small script that allowed GHC to transparently pick up on libraries installed in the user's profile. This feature has been deprecated; `ghc-wrapper` was removed from the distribution. The proper way to register Haskell libraries with the compiler now is the `haskellPackages.ghcWithPackages` function. The [User's Guide to the Haskell Infrastructure](https://nixos.org/nixpkgs/manual/#users-guide-to-the-haskell-infrastructure) provides more information about this subject.

- All Haskell builds that have been generated with version 1.x of the `cabal2nix` utility are now invalid and need to be re-generated with a current version of `cabal2nix` to function. The most recent version of this tool can be installed by running `nix-env -i cabal2nix`.

- The `haskellPackages` set in Nixpkgs used to have a function attribute called `extension` that users could override in their `~/.nixpkgs/config.nix` files to configure additional attributes, etc. That function still exists, but it's now called `overrides`.

- The OpenBLAS library has been updated to version `0.2.14`. Support for the `x86_64-darwin` platform was added. Dynamic architecture detection was enabled; OpenBLAS now selects microarchitecture-optimized routines at runtime, so optimal performance is achieved without the need to rebuild OpenBLAS locally. OpenBLAS has replaced ATLAS in most packages which use an optimized BLAS or LAPACK implementation.

- The `phpfpm` is now using the default PHP version (`pkgs.php`) instead of PHP 5.4 (`pkgs.php54`).

- The `locate` service no longer indexes the Nix store by default, preventing packages with potentially numerous versions from cluttering the output. Indexing the store can be activated by setting `services.locate.includeStore = true`.

- The Nix expression search path (`NIX_PATH`) no longer contains `/etc/nixos/nixpkgs` by default. You can override `NIX_PATH` by setting `nix.nixPath`.

- Python 2.6 has been marked as broken (as it no longer receives security updates from upstream).

- Any use of module arguments such as `pkgs` to access library functions, or to define `imports` attributes will now lead to an infinite loop at the time of the evaluation.

  In case of an infinite loop, use the `--show-trace` command line argument and read the line just above the error message.

  ```ShellSession
  $ nixos-rebuild build --show-trace
  …
  while evaluating the module argument `pkgs' in "/etc/nixos/my-module.nix":
  infinite recursion encountered
  ```

  Any use of `pkgs.lib`, should be replaced by `lib`, after adding it as argument of the module. The following module

  ```nix
  { config, pkgs, ... }:

  with pkgs.lib;

  {
    options = {
      foo = mkOption { /* … */ };
    };
    config = mkIf config.foo { /* … */ };
  }
  ```

  should be modified to look like:

  ```nix
  { config, pkgs, lib, ... }:

  with lib;

  {
    options = {
      foo = mkOption { /* option declaration */ };
    };
    config = mkIf config.foo { /* option definition */ };
  }
  ```

  When `pkgs` is used to download other projects to import their modules, and only in such cases, it should be replaced by `(import <nixpkgs> {})`. The following module

  ```nix
  { config, pkgs, ... }:

  let
    myProject = pkgs.fetchurl {
      src = url;
      sha256 = hash;
    };
  in

  {
    imports = [ "${myProject}/module.nix" ];
  }
  ```

  should be modified to look like:

  ```nix
  { config, pkgs, ... }:

  let
    myProject = (import <nixpkgs> {}).fetchurl {
      src = url;
      sha256 = hash;
    };
  in

  {
    imports = [ "${myProject}/module.nix" ];
  }
  ```

Other notable improvements:

- The nixos and nixpkgs channels were unified, so one _can_ use `nix-env -iA nixos.bash` instead of `nix-env -iA nixos.pkgs.bash`. See [the commit](https://github.com/NixOS/nixpkgs/commit/2cd7c1f198) for details.

- Users running an SSH server who worry about the quality of their `/etc/ssh/moduli` file with respect to the [vulnerabilities discovered in the Diffie-Hellman key exchange](https://stribika.github.io/2015/01/04/secure-secure-shell.html) can now replace OpenSSH's default version with one they generated themselves using the new `services.openssh.moduliFile` option.

- A newly packaged TeX Live 2015 is provided in `pkgs.texlive`, split into 6500 nix packages. For basic user documentation see [the source](https://github.com/NixOS/nixpkgs/blob/release-15.09/pkgs/tools/typesetting/tex/texlive/default.nix#L1). Beware of [an issue](https://github.com/NixOS/nixpkgs/issues/9757) when installing a too large package set. The plan is to deprecate and maybe delete the original TeX packages until the next release.

- `buildEnv.env` on all Python interpreters is now available for nix-shell interoperability.
