#!/usr/bin/env nix-shell
#!nix-shell -i bash -p cabal2nix curl jq nixfmt-rfc-style

set -euo pipefail

# This is the directory of this update.sh script.
script_dir="$(dirname "${BASH_SOURCE[0]}")"
derivation_file="${script_dir}/generated-package.nix"
latest_version="$(curl --silent 'https://api.github.com/repos/gren-lang/compiler/releases/latest' | jq --raw-output '.tag_name')"

echo "Updating gren to version ${latest_version}."
echo "Running cabal2nix and outputting to ${derivation_file}..."

cat > "${derivation_file}" << EOF
# This file has been autogenerated with cabal2nix.
# Update via ./update.sh
EOF

cabal2nix 'https://github.com/gren-lang/compiler.git' --revision "${latest_version}" --jailbreak >> "${derivation_file}"
nixfmt "${derivation_file}"

echo 'Finished.'
