{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  flask,
  flask-sqlalchemy,
  flit-core,
  marshmallow,
  marshmallow-sqlalchemy,
  pytestCheckHook,
  pythonOlder,
}:

buildPythonPackage rec {
  pname = "flask-marshmallow";
  version = "1.2.1";
  pyproject = true;

  disabled = pythonOlder "3.8";

  src = fetchFromGitHub {
    owner = "marshmallow-code";
    repo = "flask-marshmallow";
    rev = "refs/tags/${version}";
    hash = "sha256-GQLkt/CJf/QI8emvlW8xSRziGnncwfMSxBccW0Bb8I0=";
  };

  nativeBuildInputs = [ flit-core ];

  propagatedBuildInputs = [
    flask
    marshmallow
  ];

  optional-dependencies = {
    sqlalchemy = [
      flask-sqlalchemy
      marshmallow-sqlalchemy
    ];
  };

  nativeCheckInputs = [ pytestCheckHook ] ++ optional-dependencies.sqlalchemy;

  pythonImportsCheck = [ "flask_marshmallow" ];

  pytestFlagsArray = [
    "-W"
    "ignore::DeprecationWarning"
  ];

  meta = {
    description = "Flask + marshmallow for beautiful APIs";
    homepage = "https://github.com/marshmallow-code/flask-marshmallow";
    changelog = "https://github.com/marshmallow-code/flask-marshmallow/releases/tag/${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ nickcao ];
  };
}
