{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  pythonOlder,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.2.37";
  pyproject = true;

  disabled = pythonOlder "3.7";

  src = fetchPypi {
    pname = "pyExploitDb";
    inherit version;
    hash = "sha256-Z+pwss6CHy2tVz418oz2RxNYJff3x03fU7kjPkMwc5Y=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyExploitDb" ];

  meta = with lib; {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/GoVanguard/pyExploitDb";
    changelog = "https://github.com/GoVanguard/pyExploitDb/blob/master/ChangeLog.md";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ fab ];
  };
}
