{
  stdenv,
  callPackage,
  sasl,
  boost,
  Security,
  CoreFoundation,
  cctools,
  avxSupport ? stdenv.hostPlatform.avxSupport,
}:

let
  buildMongoDB = callPackage ./mongodb.nix {
    inherit
      sasl
      boost
      Security
      CoreFoundation
      cctools
      stdenv
      ;
  };
in
buildMongoDB {
  inherit avxSupport;
  version = "7.0.14";
  sha256 = "sha256-3NUv/Rr6V0rH6zHCXJwHZ7ZQOqMJvYGessNVemUF6g0=";
  patches = [
    # ModuleNotFoundError: No module named 'mongo_tooling_metrics':
    # NameError: name 'SConsToolingMetrics' is not defined:
    # The recommended linker 'lld' is not supported with the current compiler configuration, you can try the 'gold' linker with '--linker=gold'.
    ./mongodb7-SConstruct.patch

    # Fix building with python 3.12 since the imp module was removed
    ./mongodb-python312.patch
  ];
}
