# Release 18.09 ("Jellyfish", 2018/10/05) {#sec-release-18.09}

## Highlights {#sec-release-18.09-highlights}

In addition to numerous new and upgraded packages, this release has the following notable updates:

- End of support is planned for end of April 2019, handing over to 19.03.

- Platform support: x86_64-linux and x86_64-darwin as always. Support for aarch64-linux is as with the previous releases, not equivalent to the x86-64-linux release, but with efforts to reach parity.

- Nix has been updated to 2.1; see its [release notes](https://nixos.org/nix/manual/#ssec-relnotes-2.1).

- Core versions: linux: 4.14 LTS (unchanged), glibc: 2.26 → 2.27, gcc: 7 (unchanged), systemd: 237 → 239.

- Desktop version changes: gnome: 3.26 → 3.28, (KDE) plasma-desktop: 5.12 → 5.13.

Notable changes and additions for 18.09 include:

- Support for wrapping binaries using `firejail` has been added through `programs.firejail.wrappedBinaries`.

  For example

  ```nix
  {
    programs.firejail = {
      enable = true;
      wrappedBinaries = {
        firefox = "${lib.getBin pkgs.firefox}/bin/firefox";
        mpv = "${lib.getBin pkgs.mpv}/bin/mpv";
      };
    };
  }
  ```

  This will place `firefox` and `mpv` binaries in the global path wrapped by firejail.

- User channels are now in the default `NIX_PATH`, allowing users to use their personal `nix-channel` defined channels in `nix-build` and `nix-shell` commands, as well as in imports like `import <mychannel>`.

  For example

  ```ShellSession
  $ nix-channel --add https://nixos.org/channels/nixpkgs-unstable nixpkgsunstable
  $ nix-channel --update
  $ nix-build '<nixpkgsunstable>' -A gitFull
  $ nix run -f '<nixpkgsunstable>' gitFull
  $ nix-instantiate -E '(import <nixpkgsunstable> {}).gitFull'
  ```

## New Services {#sec-release-18.09-new-services}

A curated selection of new services that were added since the last release:

- The `services.cassandra` module has been reworked and was rewritten from scratch. The service has succeeding tests for the versions 2.1, 2.2, 3.0 and 3.11 of [Apache Cassandra](https://cassandra.apache.org/).

- There is a new `services.foundationdb` module for deploying [FoundationDB](https://www.foundationdb.org) clusters.

- When enabled the `iproute2` will copy the files expected by ip route (e.g., `rt_tables`) in `/etc/iproute2`. This allows to write aliases for routing tables for instance.

- `services.strongswan-swanctl` is a modern replacement for `services.strongswan`. You can use either one of them to setup IPsec VPNs but not both at the same time.

  `services.strongswan-swanctl` uses the [swanctl](https://wiki.strongswan.org/projects/strongswan/wiki/swanctl) command which uses the modern [vici](https://github.com/strongswan/strongswan/blob/master/src/libcharon/plugins/vici/README.md) _Versatile IKE Configuration Interface_. The deprecated `ipsec` command used in `services.strongswan` is using the legacy [stroke configuration interface](https://github.com/strongswan/strongswan/blob/master/README_LEGACY.md).

- The new `services.elasticsearch-curator` service periodically curates or manages, your Elasticsearch indices and snapshots.

Every new services:

- `./config/xdg/autostart.nix`

- `./config/xdg/icons.nix`

- `./config/xdg/menus.nix`

- `./config/xdg/mime.nix`

- `./hardware/brightnessctl.nix`

- `./hardware/onlykey.nix`

- `./hardware/video/uvcvideo/default.nix`

- `./misc/documentation.nix`

- `./programs/firejail.nix`

- `./programs/iftop.nix`

- `./programs/sedutil.nix`

- `./programs/singularity.nix`

- `./programs/xss-lock.nix`

- `./programs/zsh/zsh-autosuggestions.nix`

- `./services/admin/oxidized.nix`

- `./services/backup/duplicati.nix`

- `./services/backup/restic.nix`

- `./services/backup/restic-rest-server.nix`

- `./services/cluster/hadoop/default.nix`

- `./services/databases/aerospike.nix`

- `./services/databases/monetdb.nix`

- `./services/desktops/bamf.nix`

- `./services/desktops/flatpak.nix`

- `./services/desktops/zeitgeist.nix`

- `./services/development/bloop.nix`

- `./services/development/jupyter/default.nix`

- `./services/hardware/lcd.nix`

- `./services/hardware/undervolt.nix`

- `./services/misc/clipmenu.nix`

- `./services/misc/gitweb.nix`

- `./services/misc/serviio.nix`

- `./services/misc/safeeyes.nix`

- `./services/misc/sysprof.nix`

- `./services/misc/weechat.nix`

- `./services/monitoring/datadog-agent.nix`

- `./services/monitoring/incron.nix`

- `./services/networking/dnsdist.nix`

- `./services/networking/freeradius.nix`

- `./services/networking/hans.nix`

- `./services/networking/morty.nix`

- `./services/networking/ndppd.nix`

- `./services/networking/ocserv.nix`

- `./services/networking/owamp.nix`

- `./services/networking/quagga.nix`

- `./services/networking/shadowsocks.nix`

- `./services/networking/stubby.nix`

- `./services/networking/zeronet.nix`

- `./services/security/certmgr.nix`

- `./services/security/cfssl.nix`

- `./services/security/oauth2_proxy_nginx.nix`

- `./services/web-apps/virtlyst.nix`

- `./services/web-apps/youtrack.nix`

- `./services/web-servers/hitch/default.nix`

- `./services/web-servers/hydron.nix`

- `./services/web-servers/meguca.nix`

- `./services/web-servers/nginx/gitweb.nix`

- `./virtualisation/kvmgt.nix`

- `./virtualisation/qemu-guest-agent.nix`

## Backward Incompatibilities {#sec-release-18.09-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- Some licenses that were incorrectly not marked as unfree now are. This is the case for:

  - cc-by-nc-sa-20: Creative Commons Attribution Non Commercial Share Alike 2.0

  - cc-by-nc-sa-25: Creative Commons Attribution Non Commercial Share Alike 2.5

  - cc-by-nc-sa-30: Creative Commons Attribution Non Commercial Share Alike 3.0

  - cc-by-nc-sa-40: Creative Commons Attribution Non Commercial Share Alike 4.0

  - cc-by-nd-30: Creative Commons Attribution-No Derivative Works v3.00

  - msrla: Microsoft Research License Agreement

- The deprecated `services.cassandra` module has seen a complete rewrite. (See above.)

- `lib.strict` is removed. Use `builtins.seq` instead.

- The `clementine` package points now to the free derivation. `clementineFree` is removed now and `clementineUnfree` points to the package which is bundled with the unfree `libspotify` package.

- The `netcat` package is now taken directly from OpenBSD's `libressl`, instead of relying on Debian's fork. The new version should be very close to the old version, but there are some minor differences. Importantly, flags like -b, -q, -C, and -Z are no longer accepted by the nc command.

- The `services.docker-registry.extraConfig` object doesn't contain environment variables anymore. Instead it needs to provide an object structure that can be mapped onto the YAML configuration defined in [the `docker/distribution` docs](https://github.com/docker/distribution/blob/v2.6.2/docs/configuration.md).

- `gnucash` has changed from version 2.4 to 3.x. If you've been using `gnucash` (version 2.4) instead of `gnucash26` (version 2.6) you must open your Gnucash data file(s) with `gnucash26` and then save them to upgrade the file format. Then you may use your data file(s) with Gnucash 3.x. See the upgrade [documentation](https://wiki.gnucash.org/wiki/FAQ#Using_Different_Versions.2C_Up_And_Downgrade). Gnucash 2.4 is still available under the attribute `gnucash24`.

- `services.munge` now runs as user (and group) `munge` instead of root. Make sure the key file is accessible to the daemon.

- `dockerTools.buildImage` now uses `null` as default value for `tag`, which indicates that the nix output hash will be used as tag.

- The ELK stack: `elasticsearch`, `logstash` and `kibana` has been upgraded from 2.\* to 6.3.\*. The 2.\* versions have been [unsupported since last year](https://www.elastic.co/support/eol) so they have been removed. You can still use the 5.\* versions under the names `elasticsearch5`, `logstash5` and `kibana5`.

  The elastic beats: `filebeat`, `heartbeat`, `metricbeat` and `packetbeat` have had the same treatment: they now target 6.3.\* as well. The 5.\* versions are available under the names: `filebeat5`, `heartbeat5`, `metricbeat5` and `packetbeat5`

  The ELK-6.3 stack now comes with [X-Pack by default](https://www.elastic.co/products/x-pack/open). Since X-Pack is licensed under the [Elastic License](https://github.com/elastic/elasticsearch/blob/master/licenses/ELASTIC-LICENSE.txt) the ELK packages now have an unfree license. To use them you need to specify `allowUnfree = true;` in your nixpkgs configuration.

  Fortunately there is also a free variant of the ELK stack without X-Pack. The packages are available under the names: `elasticsearch-oss`, `logstash-oss` and `kibana-oss`.

- Options `boot.initrd.luks.devices.name.yubikey.ramfsMountPoint` `boot.initrd.luks.devices.name.yubikey.storage.mountPoint` were removed. `luksroot.nix` module never supported more than one YubiKey at a time anyway, hence those options never had any effect. You should be able to remove them from your config without any issues.

- `stdenv.system` and `system` in nixpkgs now refer to the host platform instead of the build platform. For native builds this is not change, let alone a breaking one. For cross builds, it is a breaking change, and `stdenv.buildPlatform.system` can be used instead for the old behavior. They should be using that anyways for clarity.

- Groups `kvm` and `render` are introduced now, as systemd requires them.

## Other Notable Changes {#sec-release-18.09-notable-changes}

- `dockerTools.pullImage` relies on image digest instead of image tag to download the image. The `sha256` of a pulled image has to be updated.

- `lib.attrNamesToStr` has been deprecated. Use more specific concatenation (`lib.concat(Map)StringsSep`) instead.

- `lib.addErrorContextToAttrs` has been deprecated. Use `builtins.addErrorContext` directly.

- `lib.showVal` has been deprecated. Use `lib.traceSeqN` instead.

- `lib.traceXMLVal` has been deprecated. Use `lib.traceValFn builtins.toXml` instead.

- `lib.traceXMLValMarked` has been deprecated. Use `lib.traceValFn (x: str + builtins.toXML x)` instead.

- The `pkgs` argument to NixOS modules can now be set directly using `nixpkgs.pkgs`. Previously, only the `system`, `config` and `overlays` arguments could be used to influence `pkgs`.

- A NixOS system can now be constructed more easily based on a preexisting invocation of Nixpkgs. For example:

  ```nix
  {
    inherit (pkgs.nixos {
      boot.loader.grub.enable = false;
      fileSystems."/".device = "/dev/xvda1";
    }) toplevel kernel initialRamdisk manual;
  }
  ```

  This benefits evaluation performance, lets you write Nixpkgs packages that depend on NixOS images and is consistent with a deployment architecture that would be centered around Nixpkgs overlays.

- `lib.traceValIfNot` has been deprecated. Use `if/then/else` and `lib.traceValSeq` instead.

- `lib.traceCallXml` has been deprecated. Please complain if you use the function regularly.

- The attribute `lib.nixpkgsVersion` has been deprecated in favor of `lib.version`. Please refer to the discussion in [NixOS/nixpkgs\#39416](https://github.com/NixOS/nixpkgs/pull/39416#discussion_r183845745) for further reference.

- `lib.recursiveUpdateUntil` was not acting according to its specification. It has been fixed to act according to the docstring, and a test has been added.

- The module for `security.dhparams` has two new options now:

  `security.dhparams.stateless`

  : Puts the generated Diffie-Hellman parameters into the Nix store instead of managing them in a stateful manner in `/var/lib/dhparams`.

  `security.dhparams.defaultBitSize`

  : The default bit size to use for the generated Diffie-Hellman parameters.

  ::: {.note}
  The path to the actual generated parameter files should now be queried using `config.security.dhparams.params.name.path` because it might be either in the Nix store or in a directory configured by `security.dhparams.path`.
  :::

  ::: {.note}
  **For developers:**

  Module implementers should not set a specific bit size in order to let users configure it by themselves if they want to have a different bit size than the default (2048).

  An example usage of this would be:

  ```nix
  { config, ... }:

  {
    security.dhparams.params.myservice = {};
    environment.etc."myservice.conf".text = ''
      dhparams = ${config.security.dhparams.params.myservice.path}
    '';
  }
  ```

  :::

- `networking.networkmanager.useDnsmasq` has been deprecated. Use `networking.networkmanager.dns` instead.

- The Kubernetes package has been bumped to major version 1.11. Please consult the [release notes](https://github.com/kubernetes/kubernetes/blob/release-1.11/CHANGELOG-1.11.md) for details on new features and api changes.

- The option `services.kubernetes.apiserver.admissionControl` was renamed to `services.kubernetes.apiserver.enableAdmissionPlugins`.

- Recommended way to access the Kubernetes Dashboard is via HTTPS (TLS) Therefore; public service port for the dashboard has changed to 443 (container port 8443) and scheme to https.

- The option `services.kubernetes.apiserver.address` was renamed to `services.kubernetes.apiserver.bindAddress`. Note that the default value has changed from 127.0.0.1 to 0.0.0.0.

- The option `services.kubernetes.apiserver.publicAddress` was not used and thus has been removed.

- The option `services.kubernetes.addons.dashboard.enableRBAC` was renamed to `services.kubernetes.addons.dashboard.rbac.enable`.

- The Kubernetes Dashboard now has only minimal RBAC permissions by default. If dashboard cluster-admin rights are desired, set `services.kubernetes.addons.dashboard.rbac.clusterAdmin` to true. On existing clusters, in order for the revocation of privileges to take effect, the current ClusterRoleBinding for kubernetes-dashboard must be manually removed: `kubectl delete clusterrolebinding kubernetes-dashboard`

- The `programs.screen` module provides allows to configure `/etc/screenrc`, however the module behaved fairly counterintuitive as the config exists, but the package wasn't available. Since 18.09 `pkgs.screen` will be added to `environment.systemPackages`.

- The module `services.networking.hostapd` now uses WPA2 by default.

- `s6Dns`, `s6Networking`, `s6LinuxUtils` and `s6PortableUtils` renamed to `s6-dns`, `s6-networking`, `s6-linux-utils` and `s6-portable-utils` respectively.

- The module option `nix.useSandbox` is now defaulted to `true`.

- The config activation script of `nixos-rebuild` now [reloads](https://www.freedesktop.org/software/systemd/man/systemctl.html#Manager%20Lifecycle%20Commands) all user units for each authenticated user.

- The default display manager is now LightDM. To use SLiM set `services.xserver.displayManager.slim.enable` to `true`.

- NixOS option descriptions are now automatically broken up into individual paragraphs if the text contains two consecutive newlines, so it's no longer necessary to use `</para><para>` to start a new paragraph.

- Top-level `buildPlatform`, `hostPlatform`, and `targetPlatform` in Nixpkgs are deprecated. Please use their equivalents in `stdenv` instead: `stdenv.buildPlatform`, `stdenv.hostPlatform`, and `stdenv.targetPlatform`.
