# Sourcehut {#module-services-sourcehut}

[Sourcehut](https://sr.ht.com/) is an open-source,
self-hostable software development platform. The server setup can be automated using
[services.sourcehut](#opt-services.sourcehut.enable).

## Basic usage {#module-services-sourcehut-basic-usage}

Sourcehut is a Python and Go based set of applications.
This NixOS module also provides basic configuration integrating Sourcehut into locally running
`services.nginx`, `services.redis.servers.sourcehut`, `services.postfix`
and `services.postgresql` services.

A very basic configuration may look like this:
```nix
{ pkgs, ... }:
let
  fqdn =
    let
      join = hostName: domain: hostName + optionalString (domain != null) ".${domain}";
    in join config.networking.hostName config.networking.domain;
in {

  networking = {
    hostName = "srht";
    domain = "tld";
    firewall.allowedTCPPorts = [ 22 80 443 ];
  };

  services.sourcehut = {
    enable = true;
    git.enable = true;
    man.enable = true;
    meta.enable = true;
    nginx.enable = true;
    postfix.enable = true;
    postgresql.enable = true;
    redis.enable = true;
    settings = {
        "sr.ht" = {
          environment = "production";
          global-domain = fqdn;
          origin = "https://${fqdn}";
          # Produce keys with srht-keygen from sourcehut.coresrht.
          network-key = "/run/keys/path/to/network-key";
          service-key = "/run/keys/path/to/service-key";
        };
        webhooks.private-key= "/run/keys/path/to/webhook-key";
    };
  };

  security.acme.certs."${fqdn}".extraDomainNames = [
    "meta.${fqdn}"
    "man.${fqdn}"
    "git.${fqdn}"
  ];

  services.nginx = {
    enable = true;
    # only recommendedProxySettings are strictly required, but the rest make sense as well.
    recommendedTlsSettings = true;
    recommendedOptimisation = true;
    recommendedGzipSettings = true;
    recommendedProxySettings = true;

    # Settings to setup what certificates are used for which endpoint.
    virtualHosts = {
      "${fqdn}".enableACME = true;
      "meta.${fqdn}".useACMEHost = fqdn;
      "man.${fqdn}".useACMEHost = fqdn;
      "git.${fqdn}".useACMEHost = fqdn;
    };
  };
}
```

  The `hostName` option is used internally to configure the nginx
reverse-proxy. The `settings` attribute set is
used by the configuration generator and the result is placed in `/etc/sr.ht/config.ini`.

## Configuration {#module-services-sourcehut-configuration}

All configuration parameters are also stored in
`/etc/sr.ht/config.ini` which is generated by
the module and linked from the store to ensure that all values from `config.ini`
can be modified by the module.

## Using an alternative webserver as reverse-proxy (e.g. `httpd`) {#module-services-sourcehut-httpd}

By default, `nginx` is used as reverse-proxy for `sourcehut`.
However, it's possible to use e.g. `httpd` by explicitly disabling
`nginx` using [](#opt-services.nginx.enable) and fixing the
`settings`.
