
# This file was @generated by crate2nix 0.10.0 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? if buildRustCrate != null
    then lib.warn "crate2nix: Passing `buildRustCrate` as argument to Cargo.nix is deprecated. If you don't customize `buildRustCrate`, replace `callPackage ./Cargo.nix {}` by `import ./Cargo.nix { inherit pkgs; }`, and if you need to customize `buildRustCrate`, use `buildRustCrateForPkgs` instead." (_: buildRustCrate)
    else pkgs: pkgs.buildRustCrate
  # Deprecated
, buildRustCrate ? null
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? []
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? lib.optionalAttrs (builtins.pathExists ./crate-config.nix) (pkgs.callPackage ./crate-config.nix {})
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "rcgen";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "rcgen" = rec {
      packageId = "rcgen";
      build = internal.buildRustCrateWithFeatures {
        packageId = "rcgen";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "asn1-rs" = rec {
        crateName = "asn1-rs";
        version = "0.3.1";
        edition = "2018";
        sha256 = "0czsk1nd4dx2k83f7jzkn8klx05wbmblkx1jh51i4c170akhbzrh";
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "asn1-rs-derive";
            packageId = "asn1-rs-derive";
          }
          {
            name = "asn1-rs-impl";
            packageId = "asn1-rs-impl";
          }
          {
            name = "displaydoc";
            packageId = "displaydoc";
          }
          {
            name = "nom";
            packageId = "nom";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "num-traits";
            packageId = "num-traits";
          }
          {
            name = "rusticata-macros";
            packageId = "rusticata-macros";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
          {
            name = "time";
            packageId = "time";
            optional = true;
            features = [ "macros" "parsing" "formatting" ];
          }
        ];
        features = {
          "bigint" = [ "num-bigint" ];
          "bits" = [ "bitvec" ];
          "bitvec" = [ "dep:bitvec" ];
          "cookie-factory" = [ "dep:cookie-factory" ];
          "datetime" = [ "time" ];
          "default" = [ "std" ];
          "num-bigint" = [ "dep:num-bigint" ];
          "serialize" = [ "cookie-factory" ];
          "time" = [ "dep:time" ];
        };
        resolvedDefaultFeatures = [ "datetime" "default" "std" "time" ];
      };
      "asn1-rs-derive" = rec {
        crateName = "asn1-rs-derive";
        version = "0.1.0";
        edition = "2018";
        sha256 = "1gzf9vab06lk0zjvbr07axx64fndkng2s28bnj27fnwd548pb2yv";
        procMacro = true;
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
          {
            name = "synstructure";
            packageId = "synstructure";
          }
        ];

      };
      "asn1-rs-impl" = rec {
        crateName = "asn1-rs-impl";
        version = "0.1.0";
        edition = "2018";
        sha256 = "1va27bn7qxqp4wanzjlkagnynv6jnrhnwmcky2ahzb1r405p6xr7";
        procMacro = true;
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];

      };
      "autocfg 0.1.7" = rec {
        crateName = "autocfg";
        version = "0.1.7";
        edition = "2015";
        sha256 = "1chwgimpx5z7xbag7krr9d8asxfqbh683qhgl9kn3hxk2l0djj8x";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "autocfg 1.0.1" = rec {
        crateName = "autocfg";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "base64" = rec {
        crateName = "base64";
        version = "0.13.0";
        edition = "2018";
        sha256 = "1z82g23mbzjgijkpcrilc7nljpxpvpf7zxf6iyiapkgka2ngwkch";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "base64ct" = rec {
        crateName = "base64ct";
        version = "1.1.1";
        edition = "2018";
        sha256 = "0p4was874qc90q2chm2i14m9mn8zmxjis8vaxihd6a2x4aqxkd76";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
          "std" = [ "alloc" ];
        };
      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.3.2";
        edition = "2018";
        sha256 = "12ki6w8gn1ldq7yz9y680llwk5gmrhrzszaa17g1sbrw2r2qvwxy";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "botan" = rec {
        crateName = "botan";
        version = "0.8.1";
        edition = "2018";
        sha256 = "08bmiyn7c3b0dgx20w6hr28d9jcq7cj78cchr84pc686sb2s41ik";
        authors = [
          "Jack Lloyd <jack@randombit.net>"
        ];
        dependencies = [
          {
            name = "botan-sys";
            packageId = "botan-sys";
          }
          {
            name = "cty";
            packageId = "cty";
          }
        ];
        features = {
          "cstr_core" = [ "dep:cstr_core" ];
          "no-std" = [ "cstr_core/alloc" ];
          "vendored" = [ "botan-sys/vendored" ];
        };
        resolvedDefaultFeatures = [ "default" "vendored" ];
      };
      "botan-src" = rec {
        crateName = "botan-src";
        version = "0.21703.0";
        edition = "2018";
        sha256 = "0s2ad9q84qsrllfsbj7hjhn7gr3hab9ng6lwzwqmimia6yvja8y8";
        authors = [
          "Rodolphe Breard <rodolphe@what.tf>"
          "Jack Lloyd <jack@randombit.net>"
        ];

      };
      "botan-sys" = rec {
        crateName = "botan-sys";
        version = "0.8.1";
        edition = "2015";
        sha256 = "1m11zblxfanrhl97j7z3ap7n17rr8j0rg91sr7f9j6y2bsniaz1x";
        authors = [
          "Jack Lloyd <jack@randombit.net>"
        ];
        dependencies = [
          {
            name = "cty";
            packageId = "cty";
          }
        ];
        buildDependencies = [
          {
            name = "botan-src";
            packageId = "botan-src";
            optional = true;
          }
        ];
        features = {
          "botan-src" = [ "dep:botan-src" ];
          "vendored" = [ "botan-src" ];
        };
        resolvedDefaultFeatures = [ "botan-src" "default" "vendored" ];
      };
      "bumpalo" = rec {
        crateName = "bumpalo";
        version = "3.9.1";
        edition = "2018";
        sha256 = "1688dv6s0cbj72p9lmll8a02a85dzxvdw2is7pji490zmd35m954";
        authors = [
          "Nick Fitzgerald <fitzgen@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "cc" = rec {
        crateName = "cc";
        version = "1.0.72";
        edition = "2018";
        crateBin = [];
        sha256 = "1vl50h2qh0nh0iddzj6gd1pnxnxpvwmbfxc30578c1pajmxi7a92";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "jobserver" = [ "dep:jobserver" ];
          "parallel" = [ "jobserver" ];
        };
      };
      "cfg-if" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "const-oid" = rec {
        crateName = "const-oid";
        version = "0.6.2";
        edition = "2018";
        sha256 = "12vv7csqqjj0x1l5mf51lgqiw76k5c3mb1yzfhfcqysks2j2lvwx";
        authors = [
          "RustCrypto Developers"
        ];
        features = {
        };
      };
      "crypto-bigint" = rec {
        crateName = "crypto-bigint";
        version = "0.2.11";
        edition = "2018";
        sha256 = "00qckh65nzb7s7vd60wylw6alxf9g37xh31lirb1qw0l8fxx6fzq";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
            optional = true;
          }
          {
            name = "rand_core";
            packageId = "rand_core";
            optional = true;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "rand" ];
          "generic-array" = [ "dep:generic-array" ];
          "rand" = [ "rand_core" ];
          "rand_core" = [ "dep:rand_core" ];
          "rlp" = [ "dep:rlp" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "default" "generic-array" "rand" "rand_core" ];
      };
      "cty" = rec {
        crateName = "cty";
        version = "0.2.2";
        edition = "2015";
        sha256 = "0d8z0pbr87wgzqqb2jk5pvj0afzc6d3rb772ach6fijhg6yglrdk";
        authors = [
          "Jorge Aparicio <jorge@japaric.io>"
        ];

      };
      "data-encoding" = rec {
        crateName = "data-encoding";
        version = "2.3.2";
        edition = "2018";
        sha256 = "0mvd8bjq5mq50fcf931cff57vwmbsvs1kpxynkzrshli98y3kqiy";
        authors = [
          "Julien Cretin <git@ia0.eu>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "der" = rec {
        crateName = "der";
        version = "0.4.5";
        edition = "2018";
        sha256 = "1x4k0jln8va1657cghl40l6p7hyvr1ixz71v9cd6imwmgp51rdvr";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "const-oid";
            packageId = "const-oid";
            optional = true;
          }
          {
            name = "crypto-bigint";
            packageId = "crypto-bigint";
            optional = true;
            features = [ "generic-array" ];
          }
        ];
        features = {
          "bigint" = [ "crypto-bigint" ];
          "const-oid" = [ "dep:const-oid" ];
          "crypto-bigint" = [ "dep:crypto-bigint" ];
          "der_derive" = [ "dep:der_derive" ];
          "derive" = [ "der_derive" ];
          "oid" = [ "const-oid" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "bigint" "const-oid" "crypto-bigint" "oid" "std" ];
      };
      "der-parser" = rec {
        crateName = "der-parser";
        version = "7.0.0";
        edition = "2018";
        sha256 = "10kfa2gzl3x20mwgrd43cyi79xgkqxyzcyrh0xylv4apa33qlfgy";
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "asn1-rs";
            packageId = "asn1-rs";
          }
          {
            name = "displaydoc";
            packageId = "displaydoc";
            usesDefaultFeatures = false;
          }
          {
            name = "nom";
            packageId = "nom";
          }
          {
            name = "num-bigint";
            packageId = "num-bigint";
            optional = true;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
          }
          {
            name = "rusticata-macros";
            packageId = "rusticata-macros";
          }
        ];
        features = {
          "bigint" = [ "num-bigint" ];
          "cookie-factory" = [ "dep:cookie-factory" ];
          "default" = [ "std" ];
          "num-bigint" = [ "dep:num-bigint" ];
          "serialize" = [ "std" "cookie-factory" ];
        };
        resolvedDefaultFeatures = [ "bigint" "default" "num-bigint" "std" ];
      };
      "digest" = rec {
        crateName = "digest";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0rmhvk33rgvd6ll71z8sng91a52rw14p0drjn1da0mqa138n1pfk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];
        features = {
          "blobby" = [ "dep:blobby" ];
          "dev" = [ "blobby" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "displaydoc" = rec {
        crateName = "displaydoc";
        version = "0.2.3";
        edition = "2018";
        sha256 = "11i8p5snlc1hs4g5q3wiyr75dn276l6kr0si5m7xmfa6y31mvy9v";
        procMacro = true;
        authors = [
          "Jane Lusby <jlusby@yaah.dev>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "foreign-types" = rec {
        crateName = "foreign-types";
        version = "0.3.2";
        edition = "2015";
        sha256 = "1cgk0vyd7r45cj769jym4a6s7vwshvd0z4bqrb92q1fwibmkkwzn";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "foreign-types-shared";
            packageId = "foreign-types-shared";
          }
        ];

      };
      "foreign-types-shared" = rec {
        crateName = "foreign-types-shared";
        version = "0.1.1";
        edition = "2015";
        sha256 = "0jxgzd04ra4imjv8jgkmdq59kj8fsz6w4zxsbmlai34h26225c00";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];

      };
      "generic-array" = rec {
        crateName = "generic-array";
        version = "0.14.5";
        edition = "2015";
        sha256 = "00qqhls43bzvyb7s26iw6knvsz3mckbxl3rhaahvypzhqwzd6j7x";
        libName = "generic_array";
        authors = [
          "Bartłomiej Kamiński <fizyk20@gmail.com>"
          "Aaron Trent <novacrazy@gmail.com>"
        ];
        dependencies = [
          {
            name = "typenum";
            packageId = "typenum";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "serde" = [ "dep:serde" ];
        };
      };
      "getrandom" = rec {
        crateName = "getrandom";
        version = "0.2.4";
        edition = "2018";
        sha256 = "0k0bdr1dyf4n9fvnkx4fmwxhv4hgnyf55gj86v4m69fln743g3a1";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "js" = [ "wasm-bindgen" "js-sys" ];
          "js-sys" = [ "dep:js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
          "wasm-bindgen" = [ "dep:wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "1.0.1";
        edition = "2018";
        sha256 = "0d8wr2qf5b25a04xf10rz9r0pdbjdgb0zaw3xvf8k2sqcz1qzaqs";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "js-sys" = rec {
        crateName = "js-sys";
        version = "0.3.56";
        edition = "2018";
        sha256 = "010g8jkj5avy3xd77i3cprjzzpfa6z9z2ay0fkllqmpx617c53x3";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
        ];

      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        dependencies = [
          {
            name = "spin";
            packageId = "spin";
            optional = true;
          }
        ];
        features = {
          "spin" = [ "dep:spin" ];
          "spin_no_std" = [ "spin" ];
        };
        resolvedDefaultFeatures = [ "spin" "spin_no_std" ];
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.116";
        edition = "2015";
        sha256 = "0x6sk17kv2fdsqxlm23bz9x1y79w90k7ylkflk44rgidhy4bspan";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "rustc-std-workspace-core" = [ "dep:rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "libm" = rec {
        crateName = "libm";
        version = "0.2.1";
        edition = "2018";
        sha256 = "0akh56sh51adhagmk9l84dyrlz60gv8ri05xhr13i1b18czkpmy7";
        authors = [
          "Jorge Aparicio <jorge@japaric.io>"
        ];
        features = {
          "musl-reference-tests" = [ "rand" ];
          "rand" = [ "dep:rand" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
          "serde" = [ "dep:serde" ];
          "sval" = [ "dep:sval" ];
          "value-bag" = [ "dep:value-bag" ];
        };
      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.1";
        edition = "2018";
        sha256 = "0smq8xzd40njqpfzv5mghigj91fzlfrfg842iz8x0wqvw2dw731h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "default" = [ "std" ];
          "libc" = [ "dep:libc" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "minimal-lexical" = rec {
        crateName = "minimal-lexical";
        version = "0.2.1";
        edition = "2018";
        sha256 = "16ppc5g84aijpri4jzv14rvcnslvlpphbszc7zzp6vfkddf4qdb8";
        authors = [
          "Alex Huszagh <ahuszagh@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "nom" = rec {
        crateName = "nom";
        version = "7.1.0";
        edition = "2018";
        sha256 = "0281jdx0xcyhjgs1jkj9pii8py1clcpazg41bgz7d71qxzhi278v";
        authors = [
          "contact@geoffroycouprie.com"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
          {
            name = "minimal-lexical";
            packageId = "minimal-lexical";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" "memchr/std" "minimal-lexical/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "num-bigint" = rec {
        crateName = "num-bigint";
        version = "0.4.3";
        edition = "2018";
        sha256 = "0py73wsa5j4izhd39nkqzqv260r0ma08vy30ky54ld3vkhlbcfpr";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "i128" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
          "default" = [ "std" ];
          "quickcheck" = [ "dep:quickcheck" ];
          "rand" = [ "dep:rand" ];
          "serde" = [ "dep:serde" ];
          "std" = [ "num-integer/std" "num-traits/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "num-bigint-dig" = rec {
        crateName = "num-bigint-dig";
        version = "0.7.0";
        edition = "2015";
        sha256 = "1004mmipvc7pvaf3kf13i1nqh3vxf789bj72d8wl51y185aywis5";
        authors = [
          "dignifiedquire <dignifiedquire@gmail.com>"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
            usesDefaultFeatures = false;
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            usesDefaultFeatures = false;
            features = [ "spin_no_std" ];
          }
          {
            name = "libm";
            packageId = "libm";
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-iter";
            packageId = "num-iter";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
          {
            name = "rand";
            packageId = "rand";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "smallvec";
            packageId = "smallvec";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "zeroize_derive" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 0.1.7";
          }
        ];
        devDependencies = [
          {
            name = "rand";
            packageId = "rand";
            features = [ "small_rng" ];
          }
        ];
        features = {
          "default" = [ "std" "i128" "u64_digit" ];
          "i128" = [ "num-integer/i128" "num-traits/i128" ];
          "prime" = [ "rand/std_rng" ];
          "rand" = [ "dep:rand" ];
          "serde" = [ "dep:serde" ];
          "std" = [ "num-integer/std" "num-traits/std" "smallvec/write" "rand/std" "serde/std" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "i128" "prime" "rand" "u64_digit" "zeroize" ];
      };
      "num-integer" = rec {
        crateName = "num-integer";
        version = "0.1.44";
        edition = "2015";
        sha256 = "1nq152y3304as1iai95hqz8prqnc94lks1s7q05sfjdmcf56kk6j";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
          "i128" = [ "num-traits/i128" ];
          "std" = [ "num-traits/std" ];
        };
        resolvedDefaultFeatures = [ "i128" "std" ];
      };
      "num-iter" = rec {
        crateName = "num-iter";
        version = "0.1.42";
        edition = "2015";
        sha256 = "0ndd9wb9qar50fdr16xm3i1zk6h2g9br56nml2n22kd56y1iq0mj";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
          "i128" = [ "num-integer/i128" "num-traits/i128" ];
          "std" = [ "num-integer/std" "num-traits/std" ];
        };
      };
      "num-traits" = rec {
        crateName = "num-traits";
        version = "0.2.14";
        edition = "2015";
        sha256 = "144j176s2p76azy2ngk2vkdzgwdc0bc8c93jhki8c9fsbknb2r4s";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libm";
            packageId = "libm";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
          "libm" = [ "dep:libm" ];
        };
        resolvedDefaultFeatures = [ "default" "i128" "libm" "std" ];
      };
      "num_threads" = rec {
        crateName = "num_threads";
        version = "0.1.3";
        edition = "2015";
        sha256 = "05gvsnv4k6d69iksz47i7fq1r61dj1k1nh4i8xrw7qlkcfx9kflp";
        authors = [
          "Jacob Pratt <open-source@jhpratt.dev>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: ((target."os" == "macos") || (target."os" == "freebsd"));
          }
        ];

      };
      "oid-registry" = rec {
        crateName = "oid-registry";
        version = "0.4.0";
        edition = "2018";
        sha256 = "0akbah3j8231ayrp2l1y5d9zmvbvqcsj0sa6s6dz6h85z8bhgqiq";
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "asn1-rs";
            packageId = "asn1-rs";
          }
        ];
        features = {
          "crypto" = [ "kdf" "pkcs1" "pkcs7" "pkcs9" "pkcs12" "nist_algs" "x962" ];
          "default" = [ "registry" ];
        };
        resolvedDefaultFeatures = [ "crypto" "default" "kdf" "nist_algs" "pkcs1" "pkcs12" "pkcs7" "pkcs9" "registry" "x509" "x962" ];
      };
      "once_cell" = rec {
        crateName = "once_cell";
        version = "1.9.0";
        edition = "2018";
        sha256 = "1mfqhrsgi368x92bwnq3vi3p5nv0n1qlrn69gfflhvkfkxfm2cns";
        authors = [
          "Aleksey Kladov <aleksey.kladov@gmail.com>"
        ];
        features = {
          "alloc" = [ "race" ];
          "atomic-polyfill" = [ "dep:atomic-polyfill" ];
          "default" = [ "std" ];
          "parking_lot" = [ "dep:parking_lot" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "race" "std" ];
      };
      "openssl" = rec {
        crateName = "openssl";
        version = "0.10.38";
        edition = "2018";
        sha256 = "15baqlphisr1f7ddq11jnrrzz4shdh35kwal24adyc2c4cif4yhc";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "foreign-types";
            packageId = "foreign-types";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "once_cell";
            packageId = "once_cell";
          }
          {
            name = "openssl-sys";
            packageId = "openssl-sys";
            rename = "ffi";
          }
        ];
        features = {
          "vendored" = [ "ffi/vendored" ];
        };
      };
      "openssl-sys" = rec {
        crateName = "openssl-sys";
        version = "0.9.72";
        edition = "2015";
        sha256 = "1jq3qbcvf16qn71yasdzw54b14n8nz98vr52l1gp60in72f10iky";
        build = "build/main.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
          {
            name = "cc";
            packageId = "cc";
          }
          {
            name = "pkg-config";
            packageId = "pkg-config";
          }
          {
            name = "vcpkg";
            packageId = "vcpkg";
            target = {target, features}: (target."env" == "msvc");
          }
        ];
        features = {
          "openssl-src" = [ "dep:openssl-src" ];
          "vendored" = [ "openssl-src" ];
        };
      };
      "pem" = rec {
        crateName = "pem";
        version = "1.0.2";
        edition = "2018";
        sha256 = "0iqrvfnm71x9pvff39d5ajwn3gc9glxlv4d4h22max7342db18z9";
        authors = [
          "Jonathan Creekmore <jonathan@thecreekmores.org>"
        ];
        dependencies = [
          {
            name = "base64";
            packageId = "base64";
          }
        ];

      };
      "pem-rfc7468" = rec {
        crateName = "pem-rfc7468";
        version = "0.2.4";
        edition = "2018";
        sha256 = "1m1c9jypydzabg4yscplmvff7pdcc8gg4cqg081hnlf03hxkmsc4";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "base64ct";
            packageId = "base64ct";
          }
        ];
        features = {
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "pkcs1" = rec {
        crateName = "pkcs1";
        version = "0.2.4";
        edition = "2018";
        sha256 = "0b2f1a0lf5h53zrjvcqbxzjhh89gcfa1myhf6z7w10ypg61fwsqi";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der";
            features = [ "bigint" "oid" ];
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468";
            optional = true;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
        ];
        features = {
          "alloc" = [ "der/alloc" "zeroize" ];
          "pem" = [ "alloc" "pem-rfc7468/alloc" ];
          "pem-rfc7468" = [ "dep:pem-rfc7468" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "pem-rfc7468" "std" "zeroize" ];
      };
      "pkcs8" = rec {
        crateName = "pkcs8";
        version = "0.7.6";
        edition = "2018";
        sha256 = "0iq46p6fa2b8xy6pj52zpmdy8ya3fg31dj4rc19x1fi69nvgjgpf";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der";
            features = [ "oid" ];
          }
          {
            name = "pem-rfc7468";
            packageId = "pem-rfc7468";
            optional = true;
          }
          {
            name = "pkcs1";
            packageId = "pkcs1";
            optional = true;
            features = [ "alloc" ];
          }
          {
            name = "spki";
            packageId = "spki";
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
        ];
        features = {
          "3des" = [ "encryption" "pkcs5/3des" ];
          "alloc" = [ "der/alloc" "zeroize" ];
          "des-insecure" = [ "encryption" "pkcs5/des-insecure" ];
          "encryption" = [ "alloc" "pkcs5/alloc" "pkcs5/pbes2" "rand_core" ];
          "pem" = [ "alloc" "pem-rfc7468/alloc" ];
          "pem-rfc7468" = [ "dep:pem-rfc7468" ];
          "pkcs1" = [ "dep:pkcs1" ];
          "pkcs5" = [ "dep:pkcs5" ];
          "rand_core" = [ "dep:rand_core" ];
          "sha1" = [ "encryption" "pkcs5/sha1" ];
          "std" = [ "alloc" "der/std" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "alloc" "pem" "pem-rfc7468" "pkcs1" "std" "zeroize" ];
      };
      "pkg-config" = rec {
        crateName = "pkg-config";
        version = "0.3.24";
        edition = "2015";
        sha256 = "1ghcyjp5537r7qigmgl3dj62j01arlpddaq93a3i414v3iskz2aq";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];

      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.16";
        edition = "2018";
        sha256 = "0wkqwnvnfcgqlrahphl45vdlgi2f1bs7nqcsalsllp1y4dp9x7zb";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "proc-macro2" = rec {
        crateName = "proc-macro2";
        version = "1.0.36";
        edition = "2018";
        sha256 = "0adh6gvs31x6pfwmygypmzrv1jc7kjq568vsqcfaxk7vhdc2sd67";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quote" = rec {
        crateName = "quote";
        version = "1.0.15";
        edition = "2018";
        sha256 = "0id1q0875pvhkg0mlb5z8gzdm2g2rbbz76bfzhv331lrm2b3wkc6";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand" = rec {
        crateName = "rand";
        version = "0.8.4";
        edition = "2018";
        sha256 = "1n5wska2fbfj4dsfz8mc0pd0dgjlrb6c9anpk5mwym345rip6x9f";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (!(target."os" == "emscripten"));
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc";
            optional = true;
            target = { target, features }: (target."os" == "emscripten");
          }
        ];
        devDependencies = [
          {
            name = "rand_hc";
            packageId = "rand_hc";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" "std_rng" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "libc" = [ "dep:libc" ];
          "log" = [ "dep:log" ];
          "packed_simd" = [ "dep:packed_simd" ];
          "rand_chacha" = [ "dep:rand_chacha" ];
          "rand_hc" = [ "dep:rand_hc" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" "rand_core/serde1" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "std_rng" = [ "rand_chacha" "rand_hc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "libc" "rand_chacha" "rand_hc" "std" "std_rng" ];
      };
      "rand_chacha" = rec {
        crateName = "rand_chacha";
        version = "0.3.1";
        edition = "2018";
        sha256 = "123x2adin558xbhvqb8w4f6syjsdkmqff8cxwhmjacpsl1ihmhg6";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];
        features = {
          "default" = [ "std" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core" = rec {
        crateName = "rand_core";
        version = "0.6.3";
        edition = "2018";
        sha256 = "1rxlxc3bpzgwphcg9c9yasvv9idipcg2z2y4j0vlb52jyl418kyk";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
          }
        ];
        features = {
          "getrandom" = [ "dep:getrandom" ];
          "serde" = [ "dep:serde" ];
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "rand_hc" = rec {
        crateName = "rand_hc";
        version = "0.3.1";
        edition = "2018";
        sha256 = "1rwpykyvhkxs4jvqdja3mzp9dqaqamzn113cxaigs9z2dmcry7nm";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];

      };
      "rcgen" = rec {
        crateName = "rcgen";
        version = "0.9.2";
        edition = "2018";
        crateBin = [
          { name = "rcgen"; path = "src/main.rs"; }
        ];
        sha256 = "0ppwfl9g504x2qwk7m7mag8c3l70w9mcfha93013nlzqdlw2vynp";
        authors = [
          "est31 <MTest31@outlook.com>"
        ];
        dependencies = [
          {
            name = "pem";
            packageId = "pem";
            optional = true;
          }
          {
            name = "ring";
            packageId = "ring";
          }
          {
            name = "time";
            packageId = "time";
            usesDefaultFeatures = false;
          }
          {
            name = "x509-parser";
            packageId = "x509-parser";
            optional = true;
            features = [ "verify" ];
          }
          {
            name = "yasna";
            packageId = "yasna";
            features = [ "time" "std" ];
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "botan";
            packageId = "botan";
            features = [ "vendored" ];
          }
          {
            name = "openssl";
            packageId = "openssl";
          }
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "rsa";
            packageId = "rsa";
          }
          {
            name = "webpki";
            packageId = "webpki";
            features = [ "std" ];
          }
          {
            name = "x509-parser";
            packageId = "x509-parser";
            features = [ "verify" ];
          }
        ];
        features = {
          "default" = [ "pem" ];
          "pem" = [ "dep:pem" ];
          "x509-parser" = [ "dep:x509-parser" ];
          "zeroize" = [ "dep:zeroize" ];
        };
        resolvedDefaultFeatures = [ "default" "pem" "x509-parser" "zeroize" ];
      };
      "ring" = rec {
        crateName = "ring";
        version = "0.16.20";
        edition = "2018";
        sha256 = "1z682xp7v38ayq9g9nkbhhfpj6ygralmlx7wdmsfv8rnw99cylrh";
        authors = [
          "Brian Smith <brian@briansmith.org>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."os" == "android") || (target."os" == "linux"));
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: ((target."os" == "android") || (target."os" == "linux"));
            features = [ "std" ];
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."os" == "dragonfly") || (target."os" == "freebsd") || (target."os" == "illumos") || (target."os" == "netbsd") || (target."os" == "openbsd") || (target."os" == "solaris"));
            features = [ "std" ];
          }
          {
            name = "spin";
            packageId = "spin";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."arch" == "x86") || (target."arch" == "x86_64") || (((target."arch" == "aarch64") || (target."arch" == "arm")) && ((target."os" == "android") || (target."os" == "fuchsia") || (target."os" == "linux"))));
          }
          {
            name = "untrusted";
            packageId = "untrusted";
          }
          {
            name = "web-sys";
            packageId = "web-sys";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."arch" == "wasm32") && (target."vendor" == "unknown") && (target."os" == "unknown") && (target."env" == ""));
            features = [ "Crypto" "Window" ];
          }
          {
            name = "winapi";
            packageId = "winapi";
            usesDefaultFeatures = false;
            target = { target, features }: (target."os" == "windows");
            features = [ "ntsecapi" "wtypesbase" ];
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = {target, features}: ((target."unix" or false) || (target."windows" or false));
          }
        ];
        features = {
          "default" = [ "alloc" "dev_urandom_fallback" ];
          "dev_urandom_fallback" = [ "once_cell" ];
          "once_cell" = [ "dep:once_cell" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "dev_urandom_fallback" "once_cell" ];
      };
      "rsa" = rec {
        crateName = "rsa";
        version = "0.5.0";
        edition = "2018";
        sha256 = "039676a4mj0875phdi7vc0bd37hv84dh0dql6fmk8dl2w81jcp70";
        authors = [
          "RustCrypto Developers"
          "dignifiedquire <dignifiedquire@gmail.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
            usesDefaultFeatures = false;
          }
          {
            name = "digest";
            packageId = "digest";
            usesDefaultFeatures = false;
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            features = [ "spin_no_std" ];
          }
          {
            name = "num-bigint-dig";
            packageId = "num-bigint-dig";
            rename = "num-bigint";
            usesDefaultFeatures = false;
            features = [ "i128" "u64_digit" "prime" "zeroize" ];
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-iter";
            packageId = "num-iter";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
            features = [ "libm" ];
          }
          {
            name = "pkcs1";
            packageId = "pkcs1";
            usesDefaultFeatures = false;
          }
          {
            name = "pkcs8";
            packageId = "pkcs8";
            usesDefaultFeatures = false;
          }
          {
            name = "rand";
            packageId = "rand";
            usesDefaultFeatures = false;
            features = [ "std_rng" ];
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
          {
            name = "zeroize";
            packageId = "zeroize";
            features = [ "alloc" "zeroize_derive" ];
          }
        ];
        features = {
          "alloc" = [ "digest/alloc" "pkcs1/alloc" "pkcs8/alloc" "pkcs8/pkcs1" ];
          "default" = [ "std" "pem" ];
          "nightly" = [ "subtle/nightly" "num-bigint/nightly" ];
          "pem" = [ "alloc" "pkcs1/pem" "pkcs8/pem" ];
          "pkcs5" = [ "pkcs8/encryption" ];
          "serde" = [ "num-bigint/serde" "serde_crate" ];
          "serde_crate" = [ "dep:serde_crate" ];
          "std" = [ "alloc" "digest/std" "pkcs1/std" "pkcs8/std" "rand/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "pem" "std" ];
      };
      "rusticata-macros" = rec {
        crateName = "rusticata-macros";
        version = "4.0.0";
        edition = "2018";
        sha256 = "03dmfxhgwzpm1360iwcpcg3y18ddgya0i0hc599am212pdvj7ib5";
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "nom";
            packageId = "nom";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
        ];

      };
      "smallvec" = rec {
        crateName = "smallvec";
        version = "1.8.0";
        edition = "2018";
        sha256 = "10zf4fn63p2d6sx8qap3jvyarcfw563308x3431hd4c34r35gpgj";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
          "arbitrary" = [ "dep:arbitrary" ];
          "const_new" = [ "const_generics" ];
          "serde" = [ "dep:serde" ];
        };
      };
      "spin" = rec {
        crateName = "spin";
        version = "0.5.2";
        edition = "2015";
        sha256 = "0b84m6dbzrwf2kxylnw82d3dr8w06av7rfkr8s85fb5f43rwyqvf";
        authors = [
          "Mathijs van de Nes <git@mathijs.vd-nes.nl>"
          "John Ericson <git@JohnEricson.me>"
        ];

      };
      "spki" = rec {
        crateName = "spki";
        version = "0.4.1";
        edition = "2018";
        sha256 = "0ckgkcg6db5y94dqhmyikgn8yrsah6pyf4j197hv1c51bp0s00aw";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "der";
            packageId = "der";
            features = [ "oid" ];
          }
        ];
        features = {
          "std" = [ "der/std" ];
        };
      };
      "subtle" = rec {
        crateName = "subtle";
        version = "2.4.1";
        edition = "2015";
        sha256 = "00b6jzh9gzb0h9n25g06nqr90z3xzqppfhhb260s1hjhh4pg7pkb";
        authors = [
          "Isis Lovecruft <isis@patternsinthevoid.net>"
          "Henry de Valence <hdevalence@hdevalence.ca>"
        ];
        features = {
          "default" = [ "std" "i128" ];
        };
      };
      "syn" = rec {
        crateName = "syn";
        version = "1.0.86";
        edition = "2018";
        sha256 = "0sqwa4nqxzm89nj8xd8sk4iz0hbrw3mb17b6hyc2w2d0zzsb6rca";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "quote" = [ "dep:quote" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "extra-traits" "full" "parsing" "printing" "proc-macro" "quote" "visit" ];
      };
      "synstructure" = rec {
        crateName = "synstructure";
        version = "0.12.6";
        edition = "2018";
        sha256 = "03r1lydbf3japnlpc4wka7y90pmz1i0danaj3f9a7b431akdlszk";
        authors = [
          "Nika Layzell <nika@thelayzells.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            usesDefaultFeatures = false;
          }
          {
            name = "syn";
            packageId = "syn";
            usesDefaultFeatures = false;
            features = [ "derive" "parsing" "printing" "clone-impls" "visit" "extra-traits" ];
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "syn/proc-macro" "quote/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "thiserror" = rec {
        crateName = "thiserror";
        version = "1.0.30";
        edition = "2018";
        sha256 = "05y4wm29ck8flwq5k1q6nhwh00a3b30cz3xr0qvnbwad5vjsnjw5";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "thiserror-impl";
            packageId = "thiserror-impl";
          }
        ];

      };
      "thiserror-impl" = rec {
        crateName = "thiserror-impl";
        version = "1.0.30";
        edition = "2018";
        sha256 = "0jviwmvx6wzawsj6c9msic7h419wmsbjagl9dzhpydkzc8zzscma";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];

      };
      "time" = rec {
        crateName = "time";
        version = "0.3.7";
        edition = "2018";
        sha256 = "0gbmwlkj15dfhbqvxlzji1ffc1lidblpgg1q3b3378hgyfcbqk00";
        authors = [
          "Jacob Pratt <open-source@jhpratt.dev>"
          "Time contributors"
        ];
        dependencies = [
          {
            name = "itoa";
            packageId = "itoa";
            optional = true;
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."family" == "unix");
          }
          {
            name = "num_threads";
            packageId = "num_threads";
            target = { target, features }: (target."family" == "unix");
          }
          {
            name = "time-macros";
            packageId = "time-macros";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "formatting" = [ "itoa" "std" ];
          "itoa" = [ "dep:itoa" ];
          "large-dates" = [ "time-macros/large-dates" ];
          "local-offset" = [ "std" ];
          "macros" = [ "time-macros" ];
          "quickcheck" = [ "quickcheck-dep" "alloc" ];
          "quickcheck-dep" = [ "dep:quickcheck-dep" ];
          "rand" = [ "dep:rand" ];
          "serde" = [ "dep:serde" ];
          "serde-human-readable" = [ "serde" "formatting" "parsing" ];
          "serde-well-known" = [ "serde/alloc" "formatting" "parsing" ];
          "std" = [ "alloc" ];
          "time-macros" = [ "dep:time-macros" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "formatting" "itoa" "macros" "parsing" "std" "time-macros" ];
      };
      "time-macros" = rec {
        crateName = "time-macros";
        version = "0.2.3";
        edition = "2018";
        sha256 = "1mj7pv8y9j2csrh1l8aabras36pgysbnfy18330srh4g8sihrsr5";
        procMacro = true;
        authors = [
          "Jacob Pratt <open-source@jhpratt.dev>"
          "Time contributors"
        ];
        features = {
        };
      };
      "typenum" = rec {
        crateName = "typenum";
        version = "1.15.0";
        edition = "2018";
        sha256 = "11yrvz1vd43gqv738yw1v75rzngjbs7iwcgzjy3cq5ywkv2imy6w";
        build = "build/main.rs";
        authors = [
          "Paho Lurie-Gregg <paho@paholg.com>"
          "Andre Bogus <bogusandre@gmail.com>"
        ];
        features = {
          "scale-info" = [ "dep:scale-info" ];
          "scale_info" = [ "scale-info/derive" ];
        };
      };
      "unicode-xid" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "untrusted" = rec {
        crateName = "untrusted";
        version = "0.7.1";
        edition = "2018";
        sha256 = "0jkbqaj9d3v5a91pp3wp9mffvng1nhycx6sh4qkdd9qyr62ccmm1";
        libPath = "src/untrusted.rs";
        authors = [
          "Brian Smith <brian@briansmith.org>"
        ];

      };
      "vcpkg" = rec {
        crateName = "vcpkg";
        version = "0.2.15";
        edition = "2015";
        sha256 = "09i4nf5y8lig6xgj3f7fyrvzd3nlaw4znrihw8psidvv5yk4xkdc";
        authors = [
          "Jim McGrath <jimmc2@gmail.com>"
        ];

      };
      "version_check" = rec {
        crateName = "version_check";
        version = "0.9.4";
        edition = "2015";
        sha256 = "0gs8grwdlgh0xq660d7wr80x14vxbizmd8dbp29p2pdncx8lp1s9";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "wasi" = rec {
        crateName = "wasi";
        version = "0.10.2+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "1ii7nff4y1mpcrxzzvbpgxm7a1nn3szjf1n21jnx37c2g6dbsvzx";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "compiler_builtins" = [ "dep:compiler_builtins" ];
          "core" = [ "dep:core" ];
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
          "rustc-std-workspace-alloc" = [ "dep:rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "wasm-bindgen" = rec {
        crateName = "wasm-bindgen";
        version = "0.2.79";
        edition = "2018";
        sha256 = "01kc4lj2vlf0ra2w63izrgdlv8p6f8p15086hhyqln6q4dsazw95";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "wasm-bindgen-macro";
            packageId = "wasm-bindgen-macro";
          }
        ];
        features = {
          "default" = [ "spans" "std" ];
          "enable-interning" = [ "std" ];
          "serde" = [ "dep:serde" ];
          "serde-serialize" = [ "serde" "serde_json" "std" ];
          "serde_json" = [ "dep:serde_json" ];
          "spans" = [ "wasm-bindgen-macro/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro/strict-macro" ];
          "xxx_debug_only_print_generated_code" = [ "wasm-bindgen-macro/xxx_debug_only_print_generated_code" ];
        };
        resolvedDefaultFeatures = [ "default" "spans" "std" ];
      };
      "wasm-bindgen-backend" = rec {
        crateName = "wasm-bindgen-backend";
        version = "0.2.79";
        edition = "2018";
        sha256 = "1jpdrl5jj01961jxhmvj7v25ws928fyfj8ms7izifnhg0ggw08cb";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "bumpalo";
            packageId = "bumpalo";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-macro" = rec {
        crateName = "wasm-bindgen-macro";
        version = "0.2.79";
        edition = "2018";
        sha256 = "00gdh0dlf2r77mxwh08q0z01vz2z7mvrllmj4gjjx9a0kvb06hig";
        procMacro = true;
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "wasm-bindgen-macro-support";
            packageId = "wasm-bindgen-macro-support";
          }
        ];
        features = {
          "spans" = [ "wasm-bindgen-macro-support/spans" ];
          "strict-macro" = [ "wasm-bindgen-macro-support/strict-macro" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-macro-support" = rec {
        crateName = "wasm-bindgen-macro-support";
        version = "0.2.79";
        edition = "2018";
        sha256 = "1g1fjqvrkrf3j20z8nxsf60cypxg9dfvpbachl2b53908q6s7a5z";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "visit" "full" ];
          }
          {
            name = "wasm-bindgen-backend";
            packageId = "wasm-bindgen-backend";
          }
          {
            name = "wasm-bindgen-shared";
            packageId = "wasm-bindgen-shared";
          }
        ];
        features = {
          "extra-traits" = [ "syn/extra-traits" ];
          "spans" = [ "wasm-bindgen-backend/spans" ];
        };
        resolvedDefaultFeatures = [ "spans" ];
      };
      "wasm-bindgen-shared" = rec {
        crateName = "wasm-bindgen-shared";
        version = "0.2.79";
        edition = "2018";
        sha256 = "18h67l9b9jn06iw9r2p7bh9i0brh24lilcp4f26f4f24bh1qv59x";
        authors = [
          "The wasm-bindgen Developers"
        ];

      };
      "web-sys" = rec {
        crateName = "web-sys";
        version = "0.3.56";
        edition = "2018";
        sha256 = "1sxqmwq773ss5m6vz7z95fdm6bqlix0s2awsy0j5gllxy8cv6q60";
        authors = [
          "The wasm-bindgen Developers"
        ];
        dependencies = [
          {
            name = "js-sys";
            packageId = "js-sys";
          }
          {
            name = "wasm-bindgen";
            packageId = "wasm-bindgen";
          }
        ];
        features = {
          "AbortSignal" = [ "EventTarget" ];
          "AnalyserNode" = [ "AudioNode" "EventTarget" ];
          "Animation" = [ "EventTarget" ];
          "AnimationEvent" = [ "Event" ];
          "AnimationPlaybackEvent" = [ "Event" ];
          "Attr" = [ "EventTarget" "Node" ];
          "AudioBufferSourceNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "AudioContext" = [ "BaseAudioContext" "EventTarget" ];
          "AudioDestinationNode" = [ "AudioNode" "EventTarget" ];
          "AudioNode" = [ "EventTarget" ];
          "AudioProcessingEvent" = [ "Event" ];
          "AudioScheduledSourceNode" = [ "AudioNode" "EventTarget" ];
          "AudioStreamTrack" = [ "EventTarget" "MediaStreamTrack" ];
          "AudioTrackList" = [ "EventTarget" ];
          "AudioWorklet" = [ "Worklet" ];
          "AudioWorkletGlobalScope" = [ "WorkletGlobalScope" ];
          "AudioWorkletNode" = [ "AudioNode" "EventTarget" ];
          "AuthenticatorAssertionResponse" = [ "AuthenticatorResponse" ];
          "AuthenticatorAttestationResponse" = [ "AuthenticatorResponse" ];
          "BaseAudioContext" = [ "EventTarget" ];
          "BatteryManager" = [ "EventTarget" ];
          "BeforeUnloadEvent" = [ "Event" ];
          "BiquadFilterNode" = [ "AudioNode" "EventTarget" ];
          "BlobEvent" = [ "Event" ];
          "Bluetooth" = [ "EventTarget" ];
          "BluetoothAdvertisingEvent" = [ "Event" ];
          "BluetoothDevice" = [ "EventTarget" ];
          "BluetoothPermissionResult" = [ "EventTarget" "PermissionStatus" ];
          "BluetoothRemoteGattCharacteristic" = [ "EventTarget" ];
          "BluetoothRemoteGattService" = [ "EventTarget" ];
          "BroadcastChannel" = [ "EventTarget" ];
          "CanvasCaptureMediaStream" = [ "EventTarget" "MediaStream" ];
          "CdataSection" = [ "CharacterData" "EventTarget" "Node" "Text" ];
          "ChannelMergerNode" = [ "AudioNode" "EventTarget" ];
          "ChannelSplitterNode" = [ "AudioNode" "EventTarget" ];
          "CharacterData" = [ "EventTarget" "Node" ];
          "ChromeWorker" = [ "EventTarget" "Worker" ];
          "Clipboard" = [ "EventTarget" ];
          "ClipboardEvent" = [ "Event" ];
          "CloseEvent" = [ "Event" ];
          "Comment" = [ "CharacterData" "EventTarget" "Node" ];
          "CompositionEvent" = [ "Event" "UiEvent" ];
          "ConstantSourceNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "ConvolverNode" = [ "AudioNode" "EventTarget" ];
          "CssAnimation" = [ "Animation" "EventTarget" ];
          "CssConditionRule" = [ "CssGroupingRule" "CssRule" ];
          "CssCounterStyleRule" = [ "CssRule" ];
          "CssFontFaceRule" = [ "CssRule" ];
          "CssFontFeatureValuesRule" = [ "CssRule" ];
          "CssGroupingRule" = [ "CssRule" ];
          "CssImportRule" = [ "CssRule" ];
          "CssKeyframeRule" = [ "CssRule" ];
          "CssKeyframesRule" = [ "CssRule" ];
          "CssMediaRule" = [ "CssConditionRule" "CssGroupingRule" "CssRule" ];
          "CssNamespaceRule" = [ "CssRule" ];
          "CssPageRule" = [ "CssRule" ];
          "CssStyleRule" = [ "CssRule" ];
          "CssStyleSheet" = [ "StyleSheet" ];
          "CssSupportsRule" = [ "CssConditionRule" "CssGroupingRule" "CssRule" ];
          "CssTransition" = [ "Animation" "EventTarget" ];
          "CustomEvent" = [ "Event" ];
          "DedicatedWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "DelayNode" = [ "AudioNode" "EventTarget" ];
          "DeviceLightEvent" = [ "Event" ];
          "DeviceMotionEvent" = [ "Event" ];
          "DeviceOrientationEvent" = [ "Event" ];
          "DeviceProximityEvent" = [ "Event" ];
          "Document" = [ "EventTarget" "Node" ];
          "DocumentFragment" = [ "EventTarget" "Node" ];
          "DocumentTimeline" = [ "AnimationTimeline" ];
          "DocumentType" = [ "EventTarget" "Node" ];
          "DomMatrix" = [ "DomMatrixReadOnly" ];
          "DomPoint" = [ "DomPointReadOnly" ];
          "DomRect" = [ "DomRectReadOnly" ];
          "DomRequest" = [ "EventTarget" ];
          "DragEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "DynamicsCompressorNode" = [ "AudioNode" "EventTarget" ];
          "Element" = [ "EventTarget" "Node" ];
          "ErrorEvent" = [ "Event" ];
          "EventSource" = [ "EventTarget" ];
          "ExtendableEvent" = [ "Event" ];
          "ExtendableMessageEvent" = [ "Event" "ExtendableEvent" ];
          "FetchEvent" = [ "Event" "ExtendableEvent" ];
          "FetchObserver" = [ "EventTarget" ];
          "File" = [ "Blob" ];
          "FileReader" = [ "EventTarget" ];
          "FileSystemDirectoryEntry" = [ "FileSystemEntry" ];
          "FileSystemFileEntry" = [ "FileSystemEntry" ];
          "FocusEvent" = [ "Event" "UiEvent" ];
          "FontFaceSet" = [ "EventTarget" ];
          "FontFaceSetLoadEvent" = [ "Event" ];
          "GainNode" = [ "AudioNode" "EventTarget" ];
          "GamepadAxisMoveEvent" = [ "Event" "GamepadEvent" ];
          "GamepadButtonEvent" = [ "Event" "GamepadEvent" ];
          "GamepadEvent" = [ "Event" ];
          "GpuDevice" = [ "EventTarget" ];
          "GpuUncapturedErrorEvent" = [ "Event" ];
          "HashChangeEvent" = [ "Event" ];
          "Hid" = [ "EventTarget" ];
          "HidConnectionEvent" = [ "Event" ];
          "HidDevice" = [ "EventTarget" ];
          "HidInputReportEvent" = [ "Event" ];
          "HtmlAnchorElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlAreaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlAudioElement" = [ "Element" "EventTarget" "HtmlElement" "HtmlMediaElement" "Node" ];
          "HtmlBaseElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlBodyElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlBrElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlButtonElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlCanvasElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDataElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDataListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDetailsElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDialogElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDirectoryElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDivElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlDocument" = [ "Document" "EventTarget" "Node" ];
          "HtmlElement" = [ "Element" "EventTarget" "Node" ];
          "HtmlEmbedElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFieldSetElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFontElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFormControlsCollection" = [ "HtmlCollection" ];
          "HtmlFormElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFrameElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlFrameSetElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHeadElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHeadingElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHrElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlHtmlElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlIFrameElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlImageElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlInputElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLabelElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLegendElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLiElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlLinkElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMapElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMediaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMenuElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMenuItemElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMetaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlMeterElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlModElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlObjectElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptGroupElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlOptionsCollection" = [ "HtmlCollection" ];
          "HtmlOutputElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlParagraphElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlParamElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlPictureElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlPreElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlProgressElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlQuoteElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlScriptElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSelectElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSlotElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSourceElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlSpanElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlStyleElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableCaptionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableCellElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableColElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableRowElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTableSectionElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTemplateElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTextAreaElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTimeElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTitleElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlTrackElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlUListElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlUnknownElement" = [ "Element" "EventTarget" "HtmlElement" "Node" ];
          "HtmlVideoElement" = [ "Element" "EventTarget" "HtmlElement" "HtmlMediaElement" "Node" ];
          "IdbCursorWithValue" = [ "IdbCursor" ];
          "IdbDatabase" = [ "EventTarget" ];
          "IdbFileHandle" = [ "EventTarget" ];
          "IdbFileRequest" = [ "DomRequest" "EventTarget" ];
          "IdbLocaleAwareKeyRange" = [ "IdbKeyRange" ];
          "IdbMutableFile" = [ "EventTarget" ];
          "IdbOpenDbRequest" = [ "EventTarget" "IdbRequest" ];
          "IdbRequest" = [ "EventTarget" ];
          "IdbTransaction" = [ "EventTarget" ];
          "IdbVersionChangeEvent" = [ "Event" ];
          "IirFilterNode" = [ "AudioNode" "EventTarget" ];
          "ImageCaptureErrorEvent" = [ "Event" ];
          "InputEvent" = [ "Event" "UiEvent" ];
          "KeyboardEvent" = [ "Event" "UiEvent" ];
          "KeyframeEffect" = [ "AnimationEffect" ];
          "LocalMediaStream" = [ "EventTarget" "MediaStream" ];
          "MediaDevices" = [ "EventTarget" ];
          "MediaElementAudioSourceNode" = [ "AudioNode" "EventTarget" ];
          "MediaEncryptedEvent" = [ "Event" ];
          "MediaKeyError" = [ "Event" ];
          "MediaKeyMessageEvent" = [ "Event" ];
          "MediaKeySession" = [ "EventTarget" ];
          "MediaQueryList" = [ "EventTarget" ];
          "MediaQueryListEvent" = [ "Event" ];
          "MediaRecorder" = [ "EventTarget" ];
          "MediaRecorderErrorEvent" = [ "Event" ];
          "MediaSource" = [ "EventTarget" ];
          "MediaStream" = [ "EventTarget" ];
          "MediaStreamAudioDestinationNode" = [ "AudioNode" "EventTarget" ];
          "MediaStreamAudioSourceNode" = [ "AudioNode" "EventTarget" ];
          "MediaStreamEvent" = [ "Event" ];
          "MediaStreamTrack" = [ "EventTarget" ];
          "MediaStreamTrackEvent" = [ "Event" ];
          "MessageEvent" = [ "Event" ];
          "MessagePort" = [ "EventTarget" ];
          "MidiAccess" = [ "EventTarget" ];
          "MidiConnectionEvent" = [ "Event" ];
          "MidiInput" = [ "EventTarget" "MidiPort" ];
          "MidiMessageEvent" = [ "Event" ];
          "MidiOutput" = [ "EventTarget" "MidiPort" ];
          "MidiPort" = [ "EventTarget" ];
          "MouseEvent" = [ "Event" "UiEvent" ];
          "MouseScrollEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "MutationEvent" = [ "Event" ];
          "NetworkInformation" = [ "EventTarget" ];
          "Node" = [ "EventTarget" ];
          "Notification" = [ "EventTarget" ];
          "NotificationEvent" = [ "Event" "ExtendableEvent" ];
          "OfflineAudioCompletionEvent" = [ "Event" ];
          "OfflineAudioContext" = [ "BaseAudioContext" "EventTarget" ];
          "OfflineResourceList" = [ "EventTarget" ];
          "OffscreenCanvas" = [ "EventTarget" ];
          "OscillatorNode" = [ "AudioNode" "AudioScheduledSourceNode" "EventTarget" ];
          "PageTransitionEvent" = [ "Event" ];
          "PaintWorkletGlobalScope" = [ "WorkletGlobalScope" ];
          "PannerNode" = [ "AudioNode" "EventTarget" ];
          "PaymentMethodChangeEvent" = [ "Event" "PaymentRequestUpdateEvent" ];
          "PaymentRequestUpdateEvent" = [ "Event" ];
          "Performance" = [ "EventTarget" ];
          "PerformanceMark" = [ "PerformanceEntry" ];
          "PerformanceMeasure" = [ "PerformanceEntry" ];
          "PerformanceNavigationTiming" = [ "PerformanceEntry" "PerformanceResourceTiming" ];
          "PerformanceResourceTiming" = [ "PerformanceEntry" ];
          "PermissionStatus" = [ "EventTarget" ];
          "PointerEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "PopStateEvent" = [ "Event" ];
          "PopupBlockedEvent" = [ "Event" ];
          "PresentationAvailability" = [ "EventTarget" ];
          "PresentationConnection" = [ "EventTarget" ];
          "PresentationConnectionAvailableEvent" = [ "Event" ];
          "PresentationConnectionCloseEvent" = [ "Event" ];
          "PresentationConnectionList" = [ "EventTarget" ];
          "PresentationRequest" = [ "EventTarget" ];
          "ProcessingInstruction" = [ "CharacterData" "EventTarget" "Node" ];
          "ProgressEvent" = [ "Event" ];
          "PromiseRejectionEvent" = [ "Event" ];
          "PublicKeyCredential" = [ "Credential" ];
          "PushEvent" = [ "Event" "ExtendableEvent" ];
          "RadioNodeList" = [ "NodeList" ];
          "RtcDataChannel" = [ "EventTarget" ];
          "RtcDataChannelEvent" = [ "Event" ];
          "RtcPeerConnection" = [ "EventTarget" ];
          "RtcPeerConnectionIceEvent" = [ "Event" ];
          "RtcTrackEvent" = [ "Event" ];
          "RtcdtmfSender" = [ "EventTarget" ];
          "RtcdtmfToneChangeEvent" = [ "Event" ];
          "Screen" = [ "EventTarget" ];
          "ScreenOrientation" = [ "EventTarget" ];
          "ScriptProcessorNode" = [ "AudioNode" "EventTarget" ];
          "ScrollAreaEvent" = [ "Event" "UiEvent" ];
          "SecurityPolicyViolationEvent" = [ "Event" ];
          "ServiceWorker" = [ "EventTarget" ];
          "ServiceWorkerContainer" = [ "EventTarget" ];
          "ServiceWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "ServiceWorkerRegistration" = [ "EventTarget" ];
          "ShadowRoot" = [ "DocumentFragment" "EventTarget" "Node" ];
          "SharedWorker" = [ "EventTarget" ];
          "SharedWorkerGlobalScope" = [ "EventTarget" "WorkerGlobalScope" ];
          "SourceBuffer" = [ "EventTarget" ];
          "SourceBufferList" = [ "EventTarget" ];
          "SpeechRecognition" = [ "EventTarget" ];
          "SpeechRecognitionError" = [ "Event" ];
          "SpeechRecognitionEvent" = [ "Event" ];
          "SpeechSynthesis" = [ "EventTarget" ];
          "SpeechSynthesisErrorEvent" = [ "Event" "SpeechSynthesisEvent" ];
          "SpeechSynthesisEvent" = [ "Event" ];
          "SpeechSynthesisUtterance" = [ "EventTarget" ];
          "StereoPannerNode" = [ "AudioNode" "EventTarget" ];
          "StorageEvent" = [ "Event" ];
          "SvgAnimateElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimateMotionElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimateTransformElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgAnimationElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgCircleElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgClipPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgComponentTransferFunctionElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgDefsElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgDescElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgElement" = [ "Element" "EventTarget" "Node" ];
          "SvgEllipseElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgFilterElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgForeignObjectElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgGeometryElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgGraphicsElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgImageElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgLineElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgLinearGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGradientElement" ];
          "SvgMarkerElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgMaskElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgMetadataElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgPathSegArcAbs" = [ "SvgPathSeg" ];
          "SvgPathSegArcRel" = [ "SvgPathSeg" ];
          "SvgPathSegClosePath" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicSmoothAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoCubicSmoothRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticRel" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticSmoothAbs" = [ "SvgPathSeg" ];
          "SvgPathSegCurvetoQuadraticSmoothRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoHorizontalAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoHorizontalRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoRel" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoVerticalAbs" = [ "SvgPathSeg" ];
          "SvgPathSegLinetoVerticalRel" = [ "SvgPathSeg" ];
          "SvgPathSegMovetoAbs" = [ "SvgPathSeg" ];
          "SvgPathSegMovetoRel" = [ "SvgPathSeg" ];
          "SvgPatternElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgPolygonElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgPolylineElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgRadialGradientElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGradientElement" ];
          "SvgRectElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGeometryElement" "SvgGraphicsElement" ];
          "SvgScriptElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgSetElement" = [ "Element" "EventTarget" "Node" "SvgAnimationElement" "SvgElement" ];
          "SvgStopElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgStyleElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgSwitchElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgSymbolElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgTextContentElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgTextElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" "SvgTextPositioningElement" ];
          "SvgTextPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" ];
          "SvgTextPositioningElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" ];
          "SvgTitleElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgUseElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgViewElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgaElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgfeBlendElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeColorMatrixElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeComponentTransferElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeCompositeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeConvolveMatrixElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDiffuseLightingElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDisplacementMapElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDistantLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeDropShadowElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeFloodElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeFuncAElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncBElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncGElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeFuncRElement" = [ "Element" "EventTarget" "Node" "SvgComponentTransferFunctionElement" "SvgElement" ];
          "SvgfeGaussianBlurElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeImageElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMergeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMergeNodeElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeMorphologyElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeOffsetElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfePointLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeSpecularLightingElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeSpotLightElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeTileElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgfeTurbulenceElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvggElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgmPathElement" = [ "Element" "EventTarget" "Node" "SvgElement" ];
          "SvgsvgElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" ];
          "SvgtSpanElement" = [ "Element" "EventTarget" "Node" "SvgElement" "SvgGraphicsElement" "SvgTextContentElement" "SvgTextPositioningElement" ];
          "TcpServerSocket" = [ "EventTarget" ];
          "TcpServerSocketEvent" = [ "Event" ];
          "TcpSocket" = [ "EventTarget" ];
          "TcpSocketErrorEvent" = [ "Event" ];
          "TcpSocketEvent" = [ "Event" ];
          "Text" = [ "CharacterData" "EventTarget" "Node" ];
          "TextTrack" = [ "EventTarget" ];
          "TextTrackCue" = [ "EventTarget" ];
          "TextTrackList" = [ "EventTarget" ];
          "TimeEvent" = [ "Event" ];
          "TouchEvent" = [ "Event" "UiEvent" ];
          "TrackEvent" = [ "Event" ];
          "TransitionEvent" = [ "Event" ];
          "UiEvent" = [ "Event" ];
          "Usb" = [ "EventTarget" ];
          "UsbConnectionEvent" = [ "Event" ];
          "UsbPermissionResult" = [ "EventTarget" "PermissionStatus" ];
          "UserProximityEvent" = [ "Event" ];
          "ValueEvent" = [ "Event" ];
          "VideoStreamTrack" = [ "EventTarget" "MediaStreamTrack" ];
          "VideoTrackList" = [ "EventTarget" ];
          "VrDisplay" = [ "EventTarget" ];
          "VttCue" = [ "EventTarget" "TextTrackCue" ];
          "WakeLockSentinel" = [ "EventTarget" ];
          "WaveShaperNode" = [ "AudioNode" "EventTarget" ];
          "WebGlContextEvent" = [ "Event" ];
          "WebKitCssMatrix" = [ "DomMatrix" "DomMatrixReadOnly" ];
          "WebSocket" = [ "EventTarget" ];
          "WheelEvent" = [ "Event" "MouseEvent" "UiEvent" ];
          "Window" = [ "EventTarget" ];
          "WindowClient" = [ "Client" ];
          "Worker" = [ "EventTarget" ];
          "WorkerDebuggerGlobalScope" = [ "EventTarget" ];
          "WorkerGlobalScope" = [ "EventTarget" ];
          "XmlDocument" = [ "Document" "EventTarget" "Node" ];
          "XmlHttpRequest" = [ "EventTarget" "XmlHttpRequestEventTarget" ];
          "XmlHttpRequestEventTarget" = [ "EventTarget" ];
          "XmlHttpRequestUpload" = [ "EventTarget" "XmlHttpRequestEventTarget" ];
          "Xr" = [ "EventTarget" ];
          "XrBoundedReferenceSpace" = [ "EventTarget" "XrReferenceSpace" "XrSpace" ];
          "XrInputSourceEvent" = [ "Event" ];
          "XrInputSourcesChangeEvent" = [ "Event" ];
          "XrReferenceSpace" = [ "EventTarget" "XrSpace" ];
          "XrReferenceSpaceEvent" = [ "Event" ];
          "XrSession" = [ "EventTarget" ];
          "XrSessionEvent" = [ "Event" ];
          "XrSpace" = [ "EventTarget" ];
          "XrViewerPose" = [ "XrPose" ];
        };
        resolvedDefaultFeatures = [ "Crypto" "EventTarget" "Window" ];
      };
      "webpki" = rec {
        crateName = "webpki";
        version = "0.22.0";
        edition = "2018";
        sha256 = "1gd1gxip5kgdwmrvhj5gjxij2mgg2mavq1ych4q1h272ja0xg5gh";
        authors = [
          "Brian Smith <brian@briansmith.org>"
        ];
        dependencies = [
          {
            name = "ring";
            packageId = "ring";
            usesDefaultFeatures = false;
          }
          {
            name = "untrusted";
            packageId = "untrusted";
          }
        ];
        features = {
          "alloc" = [ "ring/alloc" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "winapi" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "ntsecapi" "wtypesbase" ];
      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "x509-parser" = rec {
        crateName = "x509-parser";
        version = "0.13.0";
        edition = "2018";
        sha256 = "0f3fqbv92q3a3s51md94sw3vgzs934agl4ii5a6ym364mkdlpwg5";
        authors = [
          "Pierre Chifflier <chifflier@wzdftpd.net>"
        ];
        dependencies = [
          {
            name = "asn1-rs";
            packageId = "asn1-rs";
            features = [ "datetime" ];
          }
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "data-encoding";
            packageId = "data-encoding";
          }
          {
            name = "der-parser";
            packageId = "der-parser";
            features = [ "bigint" ];
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "nom";
            packageId = "nom";
          }
          {
            name = "oid-registry";
            packageId = "oid-registry";
            features = [ "crypto" "x509" ];
          }
          {
            name = "ring";
            packageId = "ring";
            optional = true;
          }
          {
            name = "rusticata-macros";
            packageId = "rusticata-macros";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
          {
            name = "time";
            packageId = "time";
            features = [ "formatting" ];
          }
        ];
        features = {
          "ring" = [ "dep:ring" ];
          "verify" = [ "ring" ];
        };
        resolvedDefaultFeatures = [ "default" "ring" "verify" ];
      };
      "yasna" = rec {
        crateName = "yasna";
        version = "0.5.0";
        edition = "2018";
        sha256 = "0k1gk11hq4rwlppv9f50bz8bnmgr73r66idpp7rybly96si38v9l";
        authors = [
          "Masaki Hara <ackie.h.gmai@gmail.com>"
        ];
        dependencies = [
          {
            name = "time";
            packageId = "time";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
        ];
        features = {
          "bit-vec" = [ "dep:bit-vec" ];
          "num-bigint" = [ "dep:num-bigint" ];
          "time" = [ "dep:time" ];
        };
        resolvedDefaultFeatures = [ "default" "std" "time" ];
      };
      "zeroize" = rec {
        crateName = "zeroize";
        version = "1.4.3";
        edition = "2018";
        sha256 = "068nvl3n5hk6lfn5y24grf2c7anzzqfzjjccscq3md7rqp79v3fn";
        authors = [
          "The RustCrypto Project Developers"
        ];
        dependencies = [
          {
            name = "zeroize_derive";
            packageId = "zeroize_derive";
            optional = true;
          }
        ];
        features = {
          "default" = [ "alloc" ];
          "zeroize_derive" = [ "dep:zeroize_derive" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "zeroize_derive" ];
      };
      "zeroize_derive" = rec {
        crateName = "zeroize_derive";
        version = "1.3.1";
        edition = "2018";
        sha256 = "1nzdqyryjnqcrqz0vhddpkd8sybhn0bd8rbd6l33rdhhxwzz3s41";
        procMacro = true;
        authors = [
          "The RustCrypto Project Developers"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
          {
            name = "synstructure";
            packageId = "synstructure";
          }
        ];

      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
    This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
    of crate given as the second argument.

    testCrateFlags: list of flags to pass to the test executable
    testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs, testPreRun, testPostRun }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    assert builtins.typeOf testPreRun == "string";
    assert builtins.typeOf testPostRun == "string";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
          # If the user hasn't set any pre/post commands, we don't want to
          # insert empty lines. This means that any existing users of crate2nix
          # don't get a spurious rebuild unless they set these explicitly.
          testCommand = pkgs.lib.concatStringsSep "\n"
            (pkgs.lib.filter (s: s != "") [
              testPreRun
              "$f $testCrateFlags 2>&1 | tee -a $out"
              testPostRun
            ]);
        in
        pkgs.runCommand "run-tests-${testCrate.name}"
          {
            inherit testCrateFlags;
            buildInputs = testInputs;
          } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            ${testCommand}
          done
        '';
    in
    pkgs.runCommand "${crate.name}-linked"
      {
        inherit (crate) outputs crateName;
        passthru = (crate.passthru or { }) // {
          inherit test;
        };
      } ''
      echo tested by ${test}
      ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
    '';

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateForPkgsFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
      # Any command to run immediatelly before a test is executed.
    , testPreRun ? ""
      # Any command run immediatelly after a test is executed.
    , testPostRun ? ""
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        , testPreRun
        , testPostRun
        }:
        let
          buildRustCrateForPkgsFuncOverriden =
            if buildRustCrateForPkgsFunc != null
            then buildRustCrateForPkgsFunc
            else
              (
                if crateOverrides == pkgs.defaultCrateOverrides
                then buildRustCrateForPkgs
                else
                  pkgs: (buildRustCrateForPkgs pkgs).override {
                    defaultCrateOverrides = crateOverrides;
                  }
              );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.crates.${packageId};
          testDrv = builtTestRustCrates.crates.${packageId};
          derivation =
            if runTests then
              crateWithTest
                {
                  crate = drv;
                  testCrate = testDrv;
                  inherit testCrateFlags testInputs testPreRun testPostRun;
                }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs testPreRun testPostRun; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
    for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateForPkgsFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
        mkBuiltByPackageIdByPkgs = pkgs:
          let
            self = {
              crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
              build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
            };
          in
          self;
        buildByPackageIdForPkgsImpl = self: pkgs: packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  # proc_macro crates must be compiled for the build architecture
                  if crateConfigs.${depPackageId}.procMacro or false
                  then self.build.crates.${depPackageId}
                  else self.crates.${depPackageId};
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  self.build.crates.${depPackageId};
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = crateConfigs."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateForPkgsFunc pkgs
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageIdByPkgs;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { buildByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: buildByPackageId dependency.packageId;
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
    be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateForPkgsFunc = _: lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateForPkgsFunc = _: crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
    features.

    This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

    If multiple paths to a dependency enable different features, the
    corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        enabledFeatures = enableFeatures (crateConfig.dependencies or [ ]) expandedFeatures;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures enabledFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = enabledFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else
                  mergePackageFeatures {
                    features = combinedFeatures;
                    featuresByPackageId = cache;
                    inherit crateConfigs packageId target runTests rootPackageId;
                  }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ enabledFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = dependency: feature:
    let
      name = dependency.rename or dependency.name;
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    feature == name || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
    rules in featureMap.

    featureMap is an attribute set which maps feature names to lists of further
    feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /* This function adds optional dependencies as features if they are enabled
    indirectly by dependency features. This function mimics Cargo's behavior
    described in a note at:
    https://doc.rust-lang.org/nightly/cargo/reference/features.html#dependency-features
  */
  enableFeatures = dependencies: features:
    assert (builtins.isList features);
    assert (builtins.isList dependencies);
    let
      additionalFeatures = lib.concatMap
        (
          dependency:
            assert (builtins.isAttrs dependency);
            let
              enabled = builtins.any (doesFeatureEnableDependency dependency) features;
            in
            if (dependency.optional or false) && enabled
            then [ (dependency.rename or dependency.name) ]
            else [ ]
        )
        dependencies;
    in
    sortedUnique (features ++ additionalFeatures);

  /*
    Returns the actual features for the given dependency.

    features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #
  };
}

